from django.db import models
from common.utils.models import BaseModel


class Organization(BaseModel):
    """Organization Model """
    id = models.AutoField(primary_key=True, help_text="自增ID")
    name = models.CharField(max_length=64,
                            unique=True,
                            null=False,
                            blank=False,
                            help_text='组织名称')
    parent = models.ForeignKey(to="self",
                               null=True,
                               blank=False,
                               related_name='child_set',
                               help_text="上级组织id",
                               on_delete=models.SET_NULL)
    enterprise_id = models.IntegerField(null=True, help_text="公司id")
    kind = models.IntegerField(null=True, help_text="组织管理团队类型")
    kind_id = models.IntegerField(null=True, help_text="关联团队")

    class Meta:
        db_table = 'organization'

    def get_relation_repr(self):
        child_orgs = map(lambda x: x.get_relation_repr(),
                         self.child_set.filter(deleted=0))
        rst = {
            'id': self.id,
            'name': self.name,
            'children': child_orgs,
        }
        return rst
