from django.urls import path
from console.order import views

urlpatterns = [
    path("", views.OrderListView.as_view()),
    path("/<int:id>/info", views.OrderInfoView.as_view()),
    path("/<int:id>/assignment", views.OrderAssignView.as_view()),
    path("/<int:id>/confirm", views.OrderRecieveConfirmView.as_view()),
    path("/work_ticket", views.OrderWorkTicketView.as_view()),
    path("/<int:id>/transfer", views.OrderTranferView.as_view()),
    path("/<int:id>/sign_in", views.OrderSignInView.as_view()),
    path("/<int:id>", views.OrderHandlerView.as_view()),
    path("/recent", views.OrderListRecent.as_view()),
    path("/material", views.MaterialView.as_view()),
    path("/material/<int:id>/info", views.MaterialView.as_view()),
    path("/material/<int:id>/edit", views.MaterialView.as_view()),
    path("/consumable_material", views.OrderAddMaterialView.as_view()),
    path("/material/<int:id>", views.OrderRemoveMaterialView.as_view()),
    path("/consumable_materials", views.OrderMaterialView.as_view()),
    path("/work_log", views.OrderWorkLogView.as_view()),
    path("/export", views.OrderExport.as_view()),
    path("/consumable_materials/<int:id>", views.MaterialUpdateView.as_view()),
    path("/work_ticket/<int:id>/info", views.WorkTicketInfoView.as_view()),
    path("/<int:id>/arrive", views.OrderArriveView.as_view()),
    path("/statistic", views.OrderStatisticView.as_view()),
    path("/<int:id>/receive", views.OrderReceiveView.as_view()),
    path("/waiting_receive", views.OrderReceiveListView.as_view()),
    path("/waiting_dispatch", views.GrabbingOrdersListView.as_view()),
    path("/<int:id>/self_assign", views.OrderAssignSelfView.as_view())
]
