from django.db.models import Q
from django_filters import rest_framework as filter


class OrderListFilter(filter.FilterSet):
    user_id = filter.NumberFilter(method="get_user_id")
    status = filter.CharFilter(method="get_status")
    name = filter.CharFilter(method="get_name")
    team_id = filter.NumberFilter(method="get_team_id")
    keyword = filter.CharFilter(method="get_keyword")

    def get_keyword(self, queryset, name, value):
        if value:
            queryset = queryset.filter(
                Q(name__icontains=value) | Q(task__name__icontains=value)
                | Q(task__customer__name__icontains=value))
        return queryset

    def get_user_id(self, queryset, name, value):
        if value:
            queryset = queryset.filter(
                Q(handler_id=value) | Q(team__team_headman_id=value))
        return queryset

    def get_status(self, queryset, name, value):
        if value:
            queryset = queryset.filter(status=value)
        return queryset

    def get_name(self, queryset, name, value):
        if value:
            queryset = queryset.filter(name__contains=value)
        return queryset

    def get_team_id(self, queryset, name, value):
        if value:
            queryset = queryset.filter(team_id=value)
        return queryset


class MaterialFilter(filter.FilterSet):
    name = filter.CharFilter(method="get_name")

    def get_name(self, queryset, name, value):
        if value:
            queryset = queryset.filter(name__contains=value)
        return queryset


class ConsumableMaterialFilter(filter.FilterSet):
    order_id = filter.NumberFilter(method="get_order")

    def get_order(self, queryset, name, value):
        if value:
            queryset = queryset.filter(order_id=value)
        return queryset
