from django.urls import path

from console.monitor import views

urlpatterns = [
    path("/manufacturers", views.MonitorManufacturerLView.as_view()),
    path("/networks", views.MonitorNetworkLView.as_view()),
    path("/templates", views.MonitorTemplateLCView.as_view()),
    path("/templates/<int:template_id>",
         views.MonitorTemplateRUDView.as_view()),
    path("/devices", views.MonitorDevicesLCView.as_view()),
    path("/devices/<int:device_id>", views.MonitorDevicesUDView.as_view()),
    path("/devices/import", views.MonitorDevicesImportCView.as_view()),
    path("/devices/import/record/<int:record_id>",
         views.MonitorDevicesImportRecordLView.as_view()),
    path("/devices/record", views.MonitorDevicesRecordLCView.as_view()),
    path("/devices/record/<int:record_id>",
         views.MonitorDevicesRecordRUDView.as_view()),
    path("/devices/record/upload",
         views.MonitorDevicesRecordUploadView.as_view()),
    path("/points", views.MonitorPointsLCView.as_view()),
    path("/points/<int:point_id>", views.MonitorPointsUDView.as_view()),
    path("/real_data", views.MonitorRealDataLView.as_view()),
    path("/range_data", views.MonitorRangeDataLView.as_view()),
    path("/test", views.TestMonitorView.as_view()),
    path("/alarm", views.MonitorAlarmLView.as_view()),
    path("/alarm/<int:alarm_id>", views.MonitorAlarmRUDView.as_view()),
    path("/numbers/<str:number>/points/<int:point_id>/data",
         views.MonitorPointDataLView.as_view()),
    path("/old/numbers/<str:number>/stations/<str:station_id>/points",
         views.StationMonitorPoints.as_view()),
    path(
        "/old/numbers/<str:number>/stations/<str:station_id>"
        "/points/<int:point_id>/real_data",
        views.StationMonitorPointsRealData.as_view()),
    path(
        "/old/numbers/<str:number>/stations/<str:station_id>"
        "/points/<int:point_id>/data",
        views.StationMonitorPointsData.as_view()),
    path(
        "/old/numbers/<str:number>/stations/<str:station_id>"
        "/points/<int:point_id>/statisticsdata",
        views.StationMonitorPointsStatisticsData.as_view()),
    path("/ht/points", views.MonitorHTPointsLCView.as_view()),
    path("/ht/real_data", views.MonitorHTRealDataLView.as_view()),
]
