import django_filters as filter
from django.db.models import Q


class MessageFilter(filter.FilterSet):
    keyword = filter.CharFilter(method="get_keyword")

    def get_keyword(self, queryset, name, value):
        if value:
            queryset = queryset.filter(
                Q(content__icontains=value)
                | Q(sender__username__icontains=value))
        return queryset
