# -*- coding=utf-8 -*-

from django.db import models
from jsonfield import JSONField

from django.utils.translation import ugettext_lazy as _
from common.utils.models import BaseModel
from common.utils.choices import EQ_TYPE, EQ_ROOT_TYPE

from console.electricityuser.models import ElectricityUser
from console.customer.models import Customer


class EquipmentData(BaseModel):
    modular = models.IntegerField(choices=EQ_ROOT_TYPE, help_text="设备模块")
    type = models.IntegerField(choices=EQ_TYPE, help_text="设备类型")

    manufacturer = models.CharField(
        max_length=128,
        default='NA',
        help_text="厂商",
        null=True,
        blank=True,
    )

    model = models.CharField(max_length=128,
                             default='NA',
                             null=True,
                             blank=True,
                             help_text="型号")

    production_date = models.DateField(
        help_text="出厂日期",
        null=True,
        blank=True,
    )

    operation_date = models.DateField(
        help_text="投运日期",
        null=True,
        blank=True,
    )
    service_life = models.DecimalField(max_digits=6,
                                       decimal_places=2,
                                       help_text="使用年限")
    production_code = models.CharField(max_length=32,
                                       default='NA',
                                       help_text="出厂设备编号")
    voltage = models.CharField(max_length=16,
                               null=True,
                               blank=True,
                               help_text="电压")
    current = models.CharField(max_length=16,
                               null=True,
                               blank=True,
                               help_text="电流")
    capacity = models.CharField(max_length=16,
                                null=True,
                                blank=True,
                                help_text="容量")
    real_capacity = models.CharField(max_length=16,
                                     null=True,
                                     blank=True,
                                     help_text="真实容量")
    status = models.BooleanField(help_text="运行状态", default=True)

    img = models.CharField(
        max_length=256,
        default='NA',
        help_text="铭牌图片",
        null=True,
        blank=True,
    )

    extra_data = JSONField(null=True, help_text="额外字段")
    comments = models.CharField(max_length=256,
                                null=True,
                                blank=True,
                                help_text="备注")

    class Meta:
        db_table = _("equipment_data")


class Equipment(BaseModel):
    name = models.CharField(max_length=128, default='NA', help_text="设备名称")
    pid = models.IntegerField(help_text="上级设备id",
                              null=True,
                              blank=True,
                              default=0)
    customer = models.ForeignKey(to=Customer,
                                 on_delete=models.SET_NULL,
                                 null=True,
                                 blank=True,
                                 help_text="所属客户")
    electricity_user = models.ForeignKey(to=ElectricityUser,
                                         on_delete=models.SET_NULL,
                                         null=True,
                                         blank=True,
                                         help_text="所属户号")
    equipment_data = models.ForeignKey(to=EquipmentData,
                                       on_delete=models.SET_NULL,
                                       null=True,
                                       blank=True,
                                       help_text="资产详情id")

    class Meta:
        db_table = _("equipments")
