from django.db import models

from common.utils.models import BaseModel
from console.customer.models import Customer

# Create your models here.
from console.team.models import Team


class ElectricityUser(BaseModel):
    """ElectricityUser Model """

    id = models.AutoField(primary_key=True, help_text="自增ID")
    number = models.CharField(max_length=64,
                              unique=True,
                              null=False,
                              blank=False,
                              help_text='户号')
    customer = models.ForeignKey(to=Customer,
                                 null=True,
                                 on_delete=models.SET_NULL,
                                 related_name='electricityuser',
                                 help_text='所属客户')
    ad_code = models.CharField(max_length=16,
                               null=True,
                               blank=True,
                               help_text="省级编码")
    city_code = models.CharField(max_length=16,
                                 null=True,
                                 blank=True,
                                 help_text="城市编码")
    district = models.CharField(max_length=16,
                                 null=True,
                                 blank=True,
                                 help_text="区县编码")
    addr = models.CharField(max_length=256,
                            null=True,
                            blank=True,
                            help_text='用电地址')
    postcode = models.CharField(max_length=32,
                                null=True,
                                blank=True,
                                help_text="邮编")
    transformer_capacity = models.FloatField(default=0, help_text='变压器容量')
    real_capacity = models.FloatField(default=0, help_text='实际容量')
    voltage_level = models.IntegerField(null=True,
                                        blank=True,
                                        help_text='电压等级')
    type = models.CharField(max_length=32,
                            null=True,
                            blank=True,
                            help_text='用电类型')
    trusteeship_num = models.FloatField(default=0, help_text='托管电站数')
    # magnification = models.FloatField(default=0, help_text='倍率')
    # power_number = models.CharField(max_length=32,
    #                                 null=False,
    #                                 blank=False,
    #                                 help_text='电源编号')
    ep_factor = models.FloatField(default=0, help_text='电功率考核因素')
    billing_method = models.CharField(max_length=16,
                                      null=True,
                                      blank=True,
                                      help_text='计费方式')
    # station_num = models.IntegerField(default=0, help_text='电站数')
    longitude = models.CharField(max_length=32,
                                 null=True,
                                 blank=True,
                                 help_text='经度')
    latitude = models.CharField(max_length=32,
                                null=True,
                                blank=True,
                                help_text='纬度')
    householder = models.CharField(max_length=64,
                                   null=True,
                                   blank=True,
                                   help_text='户主')
    phone = models.CharField(max_length=16,
                             null=True,
                             blank=True,
                             help_text='户主联系方式')
    report_contact_id = models.IntegerField(null=True, help_text='报告联系人')
    is_md = models.BooleanField(default=False, help_text="是否需量申报")
    team = models.ManyToManyField(to=Team,
                                  help_text="服务班组",
                                  db_table="ele_team")

    class Meta:
        db_table = 'electricity_user'

    def __str__(self):
        return self.number


#
# class ElectricalInfromation(BaseModel):
#     """
#     Electrical Infromation Model
#     """
#
#     id = models.AutoField(primary_key=True)
#     power_number = models.CharField(max_length=32,
#                             null=False,
#                             blank=False,
#                             help_text='电源编号')
#     meter_number = models.CharField(max_length=16,
#                             null=False,
#                             blank=False,
#                             help_text='电表号')
#     customer = models.ForeignKey(to=Customer,
#                                          on_delete=models.SET_NULL,
#                                          null=True,
#                                          help_text='所属客户')
#     electricity_user = models.ForeignKey(to=ElectricityUser,
#                                          on_delete=models.SET_NULL,
#                                          null=True,
#                                          help_text='所属户号ID')
#     incoming_line_name= models.CharField(max_length=64,
#                                      null=False,
#                                      blank=False,
#                                      help_text='进线名称')
#     tariff_type = models.CharField(max_length=16,
#                                      null=False,
#                                      blank=False,
#                                      help_text='电价类型')
#     voltage_level = models.CharField(max_length=16,
#                                      null=False,
#                                      blank=False,
#                                      help_text='电压等级')
#
#     ep_factor = models.FloatField(default=0, help_text='电功率考核因素')
#     magnification = models.FloatField(default=0, help_text='倍率')
