# Create your views here.
from common.utils.views import ManagerApiView
from console.electricity_bill.serializers import \
    CreateElectricityBillSerializer, \
    ElectricityBillSerializer, UpdateElectricityBillSerializer
from rest_framework.response import Response

from common.utils.return_structure import general_message, error_message

from common.utils.service_code import PARAMETER_ERROR, OBJ_NOT_EXIST
from console.electricity_bill.models import ElectricityBill

from common.utils.pagination import CustomPageNumberPagination
from console.electricity_bill.filters import ElectricityBillFilter

from console.electricity_bill.models import TariffType
from console.electricity_bill.serializers import TariffTypeSerializer
from console.electricity_bill.services import get_ele_bill

from console.electricity_bill.serializers import TariffTypeCreateSerializer

from console.electricity_bill.filters import CustomerBillingTypeFilter
from console.electricity_bill.models import CustomerBillingType
from console.electricity_bill.serializers import CustomerBillingTypeSerializer

from common.utils.views import BaseApiView

from console.electricityuser.models import ElectricityUser

###

# 新的电价逻辑
# select a.name,b.name,concat(
# case when distinguish_time=1 then "【分时】" when distinguish_time=0 then "【未分时】" else "" end,
# case when charge_type=1 then "【单一制】" when charge_type=2 then "【两部制】" else "" end, b.name,
# case when voltage_level=1 then "-0.4KV" when voltage_level=2 then "-10KV"
# when voltage_level=3 then "-35KV" when voltage_level=4 then "-110KV"
# when voltage_level=5 then "-220KV" when voltage_level=6 then "-20KV" else "" end,
# case when is_summer=1 then "【夏季】" else "【非夏季】" end) from ele_price_map a
# left join ele_type b
# on a.electric_type=b.id

###

class CreateElectricityBillView(ManagerApiView):
    serializer_class = CreateElectricityBillSerializer

    def post(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        if serializer.is_valid():
            instance = serializer.save()
            return Response(
                general_message(bean=ElectricityBillSerializer(instance).data))
        return Response(
            error_message(code=PARAMETER_ERROR,
                          msg_show="添加失败",
                          msg=serializer.errors))


class UpdateElectricityBillView(ManagerApiView):
    queryset = ElectricityBill.objects.filter()
    serializer_class = UpdateElectricityBillSerializer

    def put(self, request, *args, **kwargs):
        queryset = self.get_queryset().filter(
            electrical_id=kwargs.get("id"),
            year_month=request.data.get("year_month")).first()
        if not queryset:
            return Response(
                error_message(code=OBJ_NOT_EXIST,
                              msg_show="电费账单%s不存在" % kwargs.get("id")))
        serializer = self.get_serializer(queryset, data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(general_message("修改成功"))
        return Response(
            error_message(code=PARAMETER_ERROR,
                          msg_show="修改失败",
                          msg=serializer.errors))


class ElectricityBillView(ManagerApiView):
    queryset = ElectricityBill.objects.filter().prefetch_related(
        "electrical_id", "electrical_id__electricity_user",
        "electrical_id__electricity_user__customer")
    serializer_class = ElectricityBillSerializer

    def get(self, request, *args, **kwargs):
        queryset = self.get_queryset().filter(
            electrical_id=kwargs.get("id"),
            year_month=request.GET.get("year_month")).first()
        serializer = self.get_serializer(queryset)
        return Response(general_message(bean=serializer.data))


class ElectricityBillListView(ManagerApiView):
    queryset = ElectricityBill.objects.filter().prefetch_related(
        "electrical_id", "electrical_id__electricity_user",
        "electrical_id__electricity_user__customer")
    serializer_class = ElectricityBillSerializer
    filter_class = ElectricityBillFilter
    pagination_class = CustomPageNumberPagination

    def get(self, request, *args, **kwargs):
        year_month = request.GET.get("year_month")
        return Response(general_message(list=get_ele_bill(year_month)))


class TariffTypeView(ManagerApiView):
    queryset = TariffType.objects.filter()
    serializer_class = TariffTypeSerializer

    def get(self, request, *args, **kwargs):
        queryset = self.get_queryset()
        if kwargs.get("id"):
            queryset = queryset.filter(id=kwargs.get("id")).first()
            serializer = self.get_serializer(queryset)
            return Response(general_message(bean=serializer.data))
        serializer = self.get_serializer(queryset, many=True)
        return Response(general_message(list=serializer.data))


class TariffTypeCreate(ManagerApiView):
    serializer_class = TariffTypeCreateSerializer

    def post(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(general_message("添加成功"))
        return Response(
            error_message(code=PARAMETER_ERROR,
                          msg_show="添加失败",
                          msg=serializer.errors))


class TariffTypeUpdate(ManagerApiView):
    queryset = TariffType.objects.filter()
    serializer_class = TariffTypeCreateSerializer

    def post(self, request, *args, **kwargs):
        queryset = self.get_queryset().filter(id=kwargs.get("id")).first()
        if not queryset:
            return Response(
                error_message(code=PARAMETER_ERROR,
                              msg_show="电价类型%s不存在" % kwargs.get("id")))
        serializer = self.get_serializer(queryset, data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(general_message("修改成功"))
        return Response(
            error_message(code=PARAMETER_ERROR,
                          msg_show="修改失败",
                          msg=serializer.errors))


class TariffTypeDelete(ManagerApiView):
    queryset = TariffType.objects.filter()

    def delete(self, request, *args, **kwargs):
        self.get_queryset().filter(id=kwargs.get("id")).delete()
        return Response(general_message("删除成功"))


class CustomerBillingTypeView(BaseApiView):
    queryset = CustomerBillingType.objects.filter()
    serializer_class = CustomerBillingTypeSerializer
    filter_class = CustomerBillingTypeFilter

    def get(self, request, *args, **kwargs):
        ele_user = ElectricityUser.objects.filter(id=request.GET.get("ele_user")).first()
        if not ele_user:
            return Response(error_message("户号不存在"))
        instance = self.filter_queryset(self.get_queryset()).first()
        level = {
            0: "未知",
            1: "0.4KV",
            2: "10KV",
            3: "35KV",
            4: "110KV",
            5: "220KV",
            6: "20KV"
        }
        prize_type_role = {
            0: "未知",
            1: "【分】单一制 工商业及其他用电",
            2: "【分】单一制 农业生产用电",
            15: "【分】两部制 工商业及其他用电",
            4: "【分】两部制 农业生产用电",
            5: "【未】单一制 工商业及其他用电",
            6: "【未】单一制 下水道动力用电",
            7: "【未】单一制 农业生产用电",
            8: "【未】单一制 农副业动力用电",
            9: "【未】单一制 排灌动力用电",
            10: "【未】两部制 工商业及其他用电",
            11: "【未】两部制 铁合金烧碱用电",
            12: "【未】非居民 学校养老院用电",
            13: "【新】单一制 工商业及其他用电",
            14: "【新】单一制 未分时公廉租房用电",
            3: "【分】两部制 大工业用电",
            16: "未分时两部制大工业用电",
            50: "光伏发电",
            51: "湖南非工业用电"
        }
        if not instance:
            name = prize_type_role.get(int(ele_user.type)) + "-{}".format(ele_user.voltage_level)
            billing_type = TariffType.objects.filter(name__icontains=name).first()
            CustomerBillingType.objects.create(
                customer=ele_user.customer,
                ele_user=ele_user,
                billing_type=billing_type)
            instance = self.filter_queryset(self.get_queryset()).first()
        serializer = self.get_serializer(instance)
        return Response(general_message(bean=serializer.data))
