from django.urls import path

from console.electricity_bill import views

urlpatterns = [
    path("/create", views.CreateElectricityBillView.as_view()),
    path("/<int:id>/edit", views.UpdateElectricityBillView.as_view()),
    path("/<int:id>", views.ElectricityBillView.as_view()),
    path("", views.ElectricityBillListView.as_view()),
    path("/tariff_type", views.TariffTypeView.as_view()),
    path("/tariff_type/<int:id>", views.TariffTypeView.as_view()),
    path("/tariff_type/create", views.TariffTypeCreate.as_view()),
    path("/tariff_type/<int:id>/edit", views.TariffTypeUpdate.as_view()),
    path("/tariff_type/<int:id>/delete", views.TariffTypeDelete.as_view()),
    path("/customer_billing_type", views.CustomerBillingTypeView.as_view())
]
