from django.db import models

# Create your models here.
from common.utils.models import BaseModel

from console.electrical_info.models import ElectricalInfromation

from common.accounts.models import Enterprise

from console.customer.models import Customer
from console.electricityuser.models import ElectricityUser


class TariffType(BaseModel):
    name = models.CharField(max_length=64, null=True, help_text="名称")
    base_prise = models.FloatField(default=0, help_text="基础电价")
    tip_prise = models.FloatField(default=0, help_text="尖电价")
    peak_prise = models.FloatField(default=0, help_text="峰电价")
    flat_prise = models.FloatField(default=0, help_text="平电价")
    valley_prise = models.FloatField(default=0, help_text="谷电价")
    is_summer = models.BooleanField(default=False, help_text="是否分夏季用电")
    voltage_level = models.CharField(max_length=32,
                                     null=True,
                                     help_text="电压等级")
    enterprise = models.ForeignKey(to=Enterprise,
                                   on_delete=models.SET_NULL,
                                   null=True,
                                   help_text="所属客户",
                                   related_name="tariff_type_customer")
    area = models.CharField(max_length=64, null=True, help_text="地区")

    class Meta:
        db_table = "tariff_type"


class ElectricityBill(models.Model):
    electrical_id = models.ForeignKey(to=ElectricalInfromation,
                                      on_delete=models.SET_NULL,
                                      null=True,
                                      help_text="所属电源编号",
                                      db_column="electrical_id")
    year_month = models.CharField(max_length=32, null=True, help_text="年月")
    peak_volume = models.FloatField(default=0, help_text="峰电量")
    peak_volume2 = models.FloatField(default=0, help_text="峰电量2")
    tip_volume = models.FloatField(default=0, help_text="尖电量")
    tip_volume2 = models.FloatField(default=0, help_text="尖电量2")
    usual_volume = models.FloatField(default=0, help_text="平电量")
    usual_volume2 = models.FloatField(default=0, help_text="平电量2")
    valley_volume = models.FloatField(default=0, help_text="谷电量")
    valley_volume2 = models.FloatField(default=0, help_text="谷电量2")
    other_volume = models.FloatField(default=0, help_text="其他电量")
    peak_price = models.FloatField(help_text="峰电价", default=0)
    peak_price2 = models.FloatField(help_text="峰电价2", default=0)
    tip_price = models.FloatField(help_text="尖电价", default=0)
    tip_price2 = models.FloatField(help_text="尖电价2", default=0)
    usual_price = models.FloatField(help_text="平电价", default=0)
    usual_price2 = models.FloatField(help_text="平电价2", default=0)
    valley_price = models.FloatField(help_text="谷电价", default=0)
    valley_price2 = models.FloatField(help_text="谷电价2", default=0)
    other_price = models.FloatField(help_text="其他电价", default=0)
    levy_fee = models.FloatField(help_text="代征费用", default=0)
    power_factor = models.FloatField(help_text="考核功率因素", default=0)
    power_factor_real = models.FloatField(help_text="实际功率因素", default=0)
    power_factor_adjust = models.FloatField(help_text="力率", default=0)
    report_md = models.FloatField(help_text="契约限额", default=0)
    max_md = models.FloatField(default=0, help_text="最大MD")
    basic_price = models.DecimalField(max_digits=8,
                                      decimal_places=5,
                                      default=0,
                                      help_text="基本电价")
    capacity = models.IntegerField(default=0, help_text="总容量")
    idle_volume = models.IntegerField(default=0, help_text="无功电量")
    amount = models.DecimalField(max_digits=12,
                                 decimal_places=2,
                                 help_text="总金额")
    amount_adjust = models.DecimalField(max_digits=10,
                                        decimal_places=2,
                                        default=0,
                                        help_text="力率调整")
    basic_volume = models.FloatField(default=0, help_text="基本电费计费")
    epidemic_discount = models.FloatField(default=0, help_text="防疫优惠电费")
    refund_and_supplement_of_difference = models.DecimalField(default=0,
                                                              max_digits=12,
                                                              decimal_places=2,
                                                              help_text="差额退补")
    other_amount = models.DecimalField(default=0,
                                       max_digits=12,
                                       decimal_places=2,
                                       help_text="其他金额")
    file = models.CharField(max_length=256, null=True, help_text="电费账单照片")
    peak_md = models.FloatField(default=0, help_text="峰md")

    usual_md1 = models.FloatField(default=0, help_text="平1md")

    usual_md2 = models.FloatField(default=0, help_text="平2md")

    valley_md = models.FloatField(default=0, help_text="谷md")



    class Meta:
        db_table = "electricity_bill"


class CustomerBillingType(models.Model):
    customer = models.ForeignKey(to=Customer,
                                 on_delete=models.SET_NULL,
                                 null=True,
                                 related_name="billing_type_customer")
    ele_user = models.ForeignKey(to=ElectricityUser,
                                 on_delete=models.SET_NULL,
                                 null=True,
                                 related_name="ele_user_billing_type")
    ele_info = models.ForeignKey(to=ElectricalInfromation,
                                 on_delete=models.SET_NULL,
                                 null=True)
    billing_type = models.ForeignKey(to=TariffType,
                                     on_delete=models.SET_NULL,
                                     null=True,
                                     help_text="电费类型")
    billing_method = models.CharField(max_length=32,
                                      null=True,
                                      help_text="计费方式")

    class Meta:
        db_table = "customer_billing_type"
