from django.db import models
from console.customer.models import Customer
from console.electricityuser.models import ElectricityUser
from common.utils.models import BaseModel
from console.powerstation.models import PowerStation


class ElectricalInfromation(BaseModel):
    """
    Electrical Infromation Model
    """

    id = models.AutoField(primary_key=True)
    power_number = models.CharField(max_length=32,
                                    null=False,
                                    blank=False,
                                    help_text='电源编号')
    meter_number = models.CharField(max_length=32,
                                    null=False,
                                    blank=False,
                                    help_text='电表号')
    powerstation = models.ForeignKey(to=PowerStation,
                                     on_delete=models.SET_NULL,
                                     null=True,
                                     help_text='所属电站')
    incoming_line_name = models.CharField(max_length=64,
                                          null=False,
                                          blank=False,
                                          help_text='进线名称')
    electricity_user = models.ForeignKey(to=ElectricityUser,
                                         on_delete=models.SET_NULL,
                                         null=True,
                                         help_text='所属户号')
    customer = models.ForeignKey(to=Customer,
                                 null=True,
                                 on_delete=models.SET_NULL,
                                 related_name='electrical_info_user',
                                 help_text='所属客户')
    magnification = models.FloatField(default=0, help_text='倍率')
    transformer_capacity = models.FloatField(default=0, help_text='变压器容量')
    real_capacity = models.FloatField(default=0, help_text='实际容量')
    # outline_number = models.IntegerField(default=0, help_text='出线侧设备数')

    tariff_type = models.CharField(max_length=16,
                                   null=False,
                                   blank=False,
                                   help_text='电价类型')
    voltage_level = models.CharField(max_length=32,
                                     null=False,
                                     blank=False,
                                     help_text='电压等级')
    #
    ep_factor = models.CharField(max_length=32,
                                 null=True,
                                 default=0,
                                 help_text='电功率考核因素')
    # magnification = models.CharField(max_length=16,
    #                                  null=False,
    #                                  blank=False,
    #                                  help_text='倍率')
    # billing_method = models.CharField(max_length=16,
    #                                   null=False,
    #                                   blank=False,
    #                                   help_text='计费方式')
    comment = models.TextField(help_text='备注', null=True, blank=True)

    class Meta:
        db_table = 'electrical_info'
