from django_filters import rest_framework as filter

from console.dictionary.models import Dictionary


class DictionaryFilter(filter.FilterSet):
    model = filter.CharFilter(method="get_model", lookup_expr="icontains")
    name = filter.CharFilter(method="get_name", lookup_expr="icontains")

    def get_model(self, queryset, name, value):
        if value:
            queryset = queryset.filter(model__contains=value)
        return queryset

    def get_name(self, queryset, name, value):
        if value:
            queryset = queryset.filter(name__contains=value)
        return queryset

    class Meta:
        model = Dictionary
        fields = ("model", "name")


class DictionarySelectFilter(filter.FilterSet):
    model = filter.CharFilter(method="get_model")
    name = filter.CharFilter(method="get_name")

    def get_model(self, queryset, name, value):
        if value:
            queryset = queryset.filter(model=value)
        else:
            raise ValueError("model is required!")
        return queryset

    def get_name(self, queryset, name, value):
        if value:
            queryset = queryset.filter(name=value)
        else:
            raise ValueError("name is required!")
        return queryset
