from rest_framework import serializers

from console.electricityuser.models import ElectricityUser

from console.electricity_bill.models import TariffType


class PowerInfoSerializer(serializers.ModelSerializer):
    type = serializers.SerializerMethodField()

    def get_type(self, obj):
        prize_type_role = {
            0: "未知",
            1: "【分】单一制 工商业及其他用电",
            2: "【分】单一制 农业生产用电",
            15: "【分】两部制 工商业及其他用电",
            4: "【分】两部制 农业生产用电",
            5: "【未】单一制 工商业及其他用电",
            6: "【未】单一制 下水道动力用电",
            7: "【未】单一制 农业生产用电",
            8: "【未】单一制 农副业动力用电",
            9: "【未】单一制 排灌动力用电",
            10: "【未】两部制 工商业及其他用电",
            11: "【未】两部制 铁合金烧碱用电",
            12: "【未】非居民 学校养老院用电",
            13: "【新】单一制 工商业及其他用电",
            14: "【新】单一制 未分时公廉租房用电",
            3: "【分】两部制 大工业用电",
            16: "未分时两部制大工业用电",
            50: "光伏发电",
            51: "湖南非工业用电"
        }
        tariff_type = TariffType.objects.filter(
            name__icontains=prize_type_role.get(int(obj.type) if obj.type else 0)).first()
        return {
            "id": tariff_type.id,
            "name": prize_type_role.get(int(obj.type) if obj.type else 0),
            "base_prise": tariff_type.base_prise,
            "tip_prise": tariff_type.tip_prise,
            "peak_prise": tariff_type.peak_prise,
            "flat_prise": tariff_type.flat_prise,
            "valley_prise": tariff_type.valley_prise,
            "area": tariff_type.area,
        }

    class Meta:
        model = ElectricityUser
        fields = ("id", "number", "transformer_capacity", "real_capacity", "voltage_level",
                  "ep_factor", "billing_method", "type", "trusteeship_num")
