from django.db import models
from common.utils.models import BaseModel
from console.customer.models import Customer
from common.accounts.models import Enterprise, Users
from console.organizations.models import Organization


# Create your models here.
class Contract(BaseModel):
    customer = models.ForeignKey(to=Customer,
                                 on_delete=models.SET_NULL,
                                 null=True,
                                 help_text="客户")
    code = models.CharField(max_length=64, help_text="合同编号")
    business_entity = models.ForeignKey(to=Enterprise,
                                        on_delete=models.SET_NULL,
                                        null=True,
                                        help_text="业务主体",
                                        related_name="business_entity")
    organization = models.ForeignKey(to=Organization,
                                     on_delete=models.SET_NULL,
                                     null=True,
                                     help_text="业务主体",
                                     related_name="contract_org")
    contract_party = models.ForeignKey(to=Enterprise,
                                       on_delete=models.SET_NULL,
                                       null=True,
                                       help_text="签约主体",
                                       related_name="contract_party")
    salesman = models.ForeignKey(to=Users,
                                 on_delete=models.SET_NULL,
                                 null=True,
                                 help_text="业务员")
    type = models.IntegerField(null=True, help_text="合同类型")
    amount = models.DecimalField(max_digits=12,
                                 decimal_places=4,
                                 default=0,
                                 null=True,
                                 help_text="金额")
    entry_date = models.DateField(null=True, help_text="录入日期")
    effective_date = models.DateField(null=True, help_text="生效日期")
    end_date = models.DateField(null=True, help_text="结束日期")
    closed_date = models.DateField(null=True, help_text="关闭日期")
    customer_contact = models.ForeignKey(to=Users,
                                         on_delete=models.SET_NULL,
                                         null=True,
                                         help_text="客户联系人",
                                         related_name="customer_contact")
    liquidated_damages = models.DecimalField(max_digits=5,
                                             decimal_places=2,
                                             default=0,
                                             null=True,
                                             help_text="违约金比例")
    billing_period = models.IntegerField(default=0, help_text="账期")
    offer_id = models.IntegerField(null=True, default=None, help_text="报价单id")
    offer_sn = models.CharField(max_length=32,
                                null=True,
                                default=None,
                                help_text="报价单编号")
    remark = models.CharField(max_length=1024, help_text="备注", null=True)
    child = models.ForeignKey(to="self",
                              null=True,
                              blank=False,
                              related_name='child_set',
                              help_text="下级合同id",
                              on_delete=models.SET_NULL)
    sub_type = models.IntegerField(null=True, help_text="子合同类型")
    support_id = models.IntegerField(null=True, default=0, help_text="大客户技术支持")

    class Meta:
        db_table = "contract"
