import time

from common.third_party_api.luanshu_file.baseclient import BaseClient
from console.powerstation.models import PowerStation


def circuit_file_upload(file, station_id):
    client = BaseClient()
    file_id = str(time.time())
    code = client.upload_file(file, file_id=file_id)
    if not code:
        power_station = PowerStation.objects.filter(deleted=False,
                                                    id=station_id).first()
        power_station.file_id = file_id
        power_station.save()
    return code


def get_circuit_file_url(file_id):
    client = BaseClient()
    url = client.get_file_url(file_id, "viewer")
    return url
