from common.utils.models import BaseModel
from django.db import models

from common.accounts.models import Users


class Drafts(BaseModel):
    title = models.CharField(max_length=32, help_text="标题", null=True)
    index = models.CharField(max_length=32, help_text="页面唯一标识")
    content = models.TextField(help_text="内容")
    user = models.ForeignKey(to=Users,
                             on_delete=models.SET_NULL,
                             null=True,
                             help_text="用户")

    class Meta:
        db_table = "drafts"


class UserLocation(BaseModel):
    user = models.ForeignKey(to=Users,
                             on_delete=models.SET_NULL,
                             null=True,
                             help_text="人员")
    location = models.CharField(max_length=32, help_text="位置，经纬度坐标")

    class Meta:
        db_table = "user_location"


class VersionUpdate(BaseModel):
    user = models.ForeignKey(to=Users,
                             on_delete=models.SET_NULL,
                             null=True,
                             related_name="version_user")
    version = models.CharField(max_length=16, null=True, help_text="版本号")
    is_updated = models.BooleanField(default=False, help_text="是否已更新")
    package_url = models.CharField(max_length=256,
                                   null=True,
                                   help_text="安装包路径")

    class Meta:
        db_table = "version_update"


class AppVersion(BaseModel):
    version = models.CharField(max_length=16, null=True, help_text="版本号")
    package_url = models.CharField(max_length=256,
                                   null=True,
                                   help_text="安装包路径")

    class Meta:
        db_table = "app_version"
