import base64
import json
from Crypto.Cipher import AES
import requests
import logging

Logger = logging.getLogger('')


class WXBizDataCrypt:
    def __init__(self, appId, secret, sessionKey):
        self.appId = appId
        self.secret = secret
        self.sessionKey = sessionKey

    def decrypt(self, encryptedData, iv):
        # base64 decode
        sessionKey = base64.b64decode(self.sessionKey)
        encryptedData = base64.b64decode(encryptedData)
        iv = base64.b64decode(iv)

        cipher = AES.new(sessionKey, AES.MODE_CBC, iv)

        decrypted = json.loads(self._unpad(cipher.decrypt(encryptedData)))

        if decrypted['watermark']['appid'] != self.appId:
            raise Exception('Invalid Buffer')

        return decrypted

    def _unpad(self, s):
        return s[:-ord(s[len(s) - 1:])]

    # 解密获取用户信息
    def decrypt_encrypteddata(self, session_key, encryptedData, iv):
        decrypt_data = WXBizDataCrypt(self.appId, session_key)
        decrypt_data = decrypt_data.decrypt(encryptedData, iv)
        return decrypt_data

    def get_VistorInfo(self, session, request_data):
        """
        通过参数APPID, SECRET, js_code获取到用户的微信唯一标识openID和sessionKey
        通过参数encryptedData 、iv 、sessionKey 请求后台解密获取用户信息
        :param request_data: 请求参数包含encryptedData，iv，code
        :return:
        """
        try:
            encryptedData = request_data.get('encryptedData')
            iv = request_data.get('iv')
            url_code2Session = "https://api.weixin.qq.com/sns/jscode2" + \
                               "session?appid={}&secret={}&js_code={}" \
                               .format(self.appId, self.secret,
                                       request_data.get('code')) + \
                               "&grant_type=authorization_code"
            data = requests.get(url_code2Session)
            if data.status_code == 200:
                data_content = json.loads(data.content)
                if 'session_key' in data_content:
                    session_key = data_content['session_key']
                    user_info = self.decrypt_encrypteddata(
                        session_key, encryptedData, iv)
                    open_id = user_info.get('openId')  # 微信用户唯一标识
                    session['open_id'] = open_id  # 将微信唯一标识open_id存在session中
                    session[
                        'session_key'] = session_key  # 将session_key存在session中
                    # 这里是自己的逻辑实现，例如将用户信息存储到数据库中
                    # 这里是自己的逻辑实现，例如将用户信息存储到数据库中
                    # 这里是自己的逻辑实现，例如将用户信息存储到数据库中
                    res = {'code': 1, 'message': '用户已登录'}
                else:
                    res = {'code': 2, 'message': '用户未登录'}
            else:
                res = {'code': 2, 'message': '用户未登录'}
            return res
        except Exception as e:
            error_info = '用户登录失败：{}'.format(e)
            Logger.error(error_info)
