# -*- coding: utf-8 -*-


def is_number(s):
    try:
        float(s)
        return True
    except ValueError:
        pass
    try:
        import unicodedata
        unicodedata.numeric(s)
        return True
    except (TypeError, ValueError):
        pass
    return False


def to_int(s):
    try:
        return int(s)
    except (TypeError, ValueError):
        return s


def general_message(msg_show=None,
                    msg="success",
                    code=100000,
                    bean={},
                    list=[],
                    *args,
                    **kwargs):
    count = to_int(kwargs.pop("count", 0))
    page = to_int(kwargs.pop("page", None))
    page_size = to_int(kwargs.pop("page_size", None))
    """通用响应信息"""
    return {
        "code": code,
        "msg": msg,
        "msg_show": msg_show,
        "count": count,
        "page_size": page_size,
        "page": page,
        "data": dict(bean={} or bean, list=list or [], *args, **kwargs),
    }


def error_message(code, msg="", msg_show="", **kwargs):
    """错误响应信息"""
    return {"code": code, "msg": msg, "msg_show": msg_show, **kwargs}


def openapi_message(msg_show=None, msg="success", code=10000, **kwargs):
    """通用响应信息"""
    return {
        "code": code,
        "msg": msg,
        "msg_show": msg_show,
        "count": int(kwargs.get("count") or 0),
        **kwargs,
    }
