from typing import Dict

basicDataPlatform = ["module", "基础数据平台", 1000000]

customerInformationModel = ["module", "客户信息管理", 1010000]

customerModel = ["module", "客户管理", 1010100]
customerDescribe = ["describe", "查看客户", 1010101]
customerCreate = ["create", "创建客户", 1010102]
customerEdit = ["edit", "编辑客户", 1010103]
customerDelete = ["delete", "删除客户", 1010104]

numberModel = ["module", "户号管理", 1010200]
numberDescribe = ["describe", "户号查看", 1010201]
numberCreate = ["create", "户号创建", 1010202]
numberEdit = ["edit", "户号编辑", 1010203]
numberDelete = ["delete", "户号删除", 1010204]

powerStationModel = ["module", "电站管理", 1010300]
powerStationDescribe = ["describe", "查看电站", 1010301]
powerStationCreate = ["create", "创建", 1010302]
powerStationEdit = ["edit", "编辑电站", 1010303]
powerStationDelete = ["delete", "删除电站", 1010304]

contractModel = ["module", "合同管理", 1010400]
contractDescribe = ["describe", "查看合同", 1010401]
contractCreate = ["create", "创建合同", 1010402]
contractEdit = ["edit", "编辑合同", 1010403]
contractDelete = ["delete", "删除合同", 1010404]

carManageModel = ["module", "车辆管理", 1020000]

carInfoModel = ["module", "车辆管理", 1020100]
carInfoDescribe = ["describe", "查看车辆", 1020101]
carInfoCreate = ["create", "创建车辆", 1020102]
carInfoEdit = ["edit", "编辑车辆", 1020103]
carInfoDelete = ["delete", "删除车辆", 1020104]

# customerAssetsManageModel = ["module", "客户资产管理", 1030000]
#
# customerAssetsInfoModel = ["module", "客户资产管理", 1030100]
# customerAssetsInfoDescribe = ["describe", "查看客户资产", 1030101]
# customerAssetsInfoCreate = ["create", "创建客户资产", 1030102]
# customerAssetsInfoEdit = ["edit", "编辑客户资产", 1030103]
# customerAssetsInfoDelete = ["delete", "删除客户资产", 1030104]

systemModel = ["module", "集团管理", 1040000]

userModel = ["module", "用户管理", 1040100]
userDescribe = ["describe", "查看用户", 1040101]
userCreate = ["create", "创建用户", 1040102]
userEdit = ["edit", "编辑用户", 1040103]
userDelete = ["delete", "删除用户", 1040104]

roleModel = ["module", "角色管理", 1040200]
roleDescribe = ["describe", "查看角色", 1040201]
roleCreate = ["create", "创建角色", 1040202]
roleEdit = ["edit", "编辑角色", 1040203]
roleDelete = ["delete", "删除角色", 1040204]

organizationModel = ["module", "组织管理", 1040300]
organizationDescribe = ["describe", "查看组织", 1040301]
organizationCreate = ["create", "创建组织", 1040302]
organizationEdit = ["edit", "编辑组织", 1040303]
organizationDelete = ["delete", "删除组织", 1040304]

messageModel = ["module", "消息管理", 1040400]
messageDescribe = ["describe", "查看消息", 1040401]
messageCreate = ["create", "创建消息", 1040402]
messageEdit = ["edit", "编辑消息", 1040403]
messageDelete = ["delete", "删除消息", 1040404]

dictionaryModel = ["module", "字典管理", 1040500]
dictionaryDescribe = ["describe", "查看字典", 1040501]
dictionaryCreate = ["create", "创建字典", 1040502]
dictionaryEdit = ["edit", "编辑字典", 1040503]
dictionaryDelete = ["delete", "删除字典", 1040504]

sysMonitorModel = ["module", "系统监控", 1040600]
sysMonitorDescribe = ["describe", "查看系统监控", 1040601]
sysMonitorCreate = ["create", "创建系统监控", 1040602]
sysMonitorEdit = ["edit", "编辑系统监控", 1040603]
sysMonitorDelete = ["delete", "删除系统监控", 1040604]

operationRecordModel = ["module", "操作记录", 1040700]
operationRecordDescribe = ["describe", "查看操作记录", 1040701]
operationRecordCreate = ["create", "创建操作记录", 1040702]
operationRecordEdit = ["edit", "编辑操作记录", 1040703]
operationRecordDelete = ["delete", "删除操作记录", 1040704]

IOTPlatform = ["module", "IOT平台", 2000000]

powerMonitorManageModel = ["module", "电力监控管理", 2010000]

monitorApprovalModel = ["module", "监控审批单", 2010100]
monitorApprovalDescribe = ["describe", "查看监控审批单", 2010101]
monitorApprovalCreate = ["create", "创建监控审批单", 2010102]
monitorApprovalEdit = ["edit", "编辑监控审批单", 2010103]
monitorApprovalDelete = ["delete", "删除监控审批单", 2010104]

monitorPointManageModel = ["module", "监控点位管理", 2010200]
monitorPointManageDescribe = ["describe", "查看监控点位", 2010201]
monitorPointManageCreate = ["create", "创建监控点位", 2010202]
monitorPointManageEdit = ["edit", "编辑监控点位", 2010203]
monitorPointManageDelete = ["delete", "删除监控点位", 2010204]

monitorDevicesModel = ["module", "监控设备", 2010300]
monitorDevicesDescribe = ["describe", "查看监控设备", 2010301]
monitorDevicesCreate = ["create", "创建监控设备", 2010302]
monitorDevicesEdit = ["edit", "编辑监控设备", 2010303]
monitorDevicesDelete = ["delete", "删除监控设备", 2010304]

alarmTemplateModel = ["module", "告警策略模板", 2010400]
alarmTemplateDescribe = ["describe", "查看告警策略模板", 2010401]
alarmTemplateCreate = ["create", "创建告警策略模板", 2010402]
alarmTemplateEdit = ["edit", "编辑告警策略模板", 2010403]
alarmTemplateDelete = ["delete", "删除告警策略模板", 2010404]

alarmRecordModel = ["module", "告警记录", 2010500]
alarmRecordDescribe = ["describe", "查看告警记录", 2010501]
alarmRecordCreate = ["create", "创建告警记录", 2010502]
alarmRecordEdit = ["edit", "编辑告警记录", 2010503]
alarmRecordDelete = ["delete", "删除告警记录", 2010504]

ICCIDManageModel = ["module", "物联网卡台账", 2020000]
ICCIDModel = ["module", "物联网卡管理", 2020100]
ICCIDDescribe = ["describe", "查看物联网卡管理", 2020101]
ICCIDCreate = ["create", "创建物联网卡管理", 2020102]
ICCIDEdit = ["edit", "编辑物联网卡管理", 2020103]
ICCIDDelete = ["delete", "删除物联网卡管理", 2020104]

monitorVideoManageModel = ["module", "视频监控管理", 2030000]
monitorVideoModel = ["module", "视频监控", 2030100]
monitorVideoDescribe = ["describe", "查看视频监控", 2030101]
monitorVideoCreate = ["create", "创建视频监控", 2030102]
monitorVideoEdit = ["edit", "编辑视频监控", 2030103]
monitorVideoDelete = ["delete", "删除视频监控", 2030104]

inspectionRobotManageModel = ["module", "巡检机器人管理", 2040000]
inspectionRobotModel = ["module", "巡检机器人", 2040100]
inspectionRobotDescribe = ["describe", "查看巡检机器人", 2040101]
inspectionRobotCreate = ["create", "创建巡检机器人", 2040102]
inspectionRobotEdit = ["edit", "编辑巡检机器人", 2040103]
inspectionRobotDelete = ["delete", "删除巡检机器人", 2040104]

otherIOTDevicesManageModel = ["module", "其他IOT设备管理", 2050000]
otherIOTDevicesModel = ["module", "其他IOT设备", 2050100]
otherIOTDevicesDescribe = ["describe", "查看其他IOT设备", 2050101]
otherIOTDevicesCreate = ["create", "创建其他IOT设备", 2050102]
otherIOTDevicesEdit = ["edit", "编辑其他IOT设备", 2050103]
otherIOTDevicesDelete = ["delete", "删除其他IOT设备", 2050104]

businessPlatform = ["module", "业务平台", 3000000]

trusteeshipCustomerManageModel = ["module", "托管客户", 3010000]
trusteeshipCustomerModel = ["module", "托管客户", 3010100]
trusteeshipCustomerDescribe = ["describe", "查看托管客户", 3010101]
trusteeshipCustomerCreate = ["create", "创建托管客户", 3010102]
trusteeshipCustomerEdit = ["edit", "编辑托管客户", 3010103]
trusteeshipCustomerDelete = ["delete", "删除托管客户", 3010104]

inspectionOperationManageModel = ["module", "巡检运维", 3020000]

inspectionPlanModel = ["module", "巡检计划", 3020100]
inspectionPlanDescribe = ["describe", "查看巡检计划", 3020101]
inspectionPlanCreate = ["create", "创建巡检计划", 3020102]
inspectionPlanEdit = ["edit", "编辑巡检计划", 3020103]
inspectionPlanDelete = ["delete", "删除巡检计划", 3020104]

inspectionTaskModel = ["module", "巡检任务", 3020200]
inspectionTaskDescribe = ["describe", "查看巡检任务", 3020201]
inspectionTaskCreate = ["create", "创建巡检任务", 3020202]
inspectionTaskEdit = ["edit", "编辑巡检任务", 3020203]
inspectionTaskDelete = ["delete", "删除巡检任务", 3020204]

inspectionRecordModel = ["module", "巡检任务", 3020300]
inspectionRecordDescribe = ["describe", "查看巡检任务", 3020301]
inspectionRecordCreate = ["create", "创建巡检任务", 3020302]
inspectionRecordEdit = ["edit", "编辑巡检任务", 3020303]
inspectionRecordDelete = ["delete", "删除巡检任务", 3020304]

defectModel = ["module", "缺陷管理", 3020400]
defectDescribe = ["describe", "查看缺陷", 3020401]
defectCreate = ["create", "创建缺陷", 3020402]
defectEdit = ["edit", "编辑缺陷", 3020403]
defectDelete = ["delete", "删除缺陷", 3020404]

teamManageModel = ["module", "班组管理", 3030000]
teamModel = ["module", "班组管理", 3030100]
teamDescribe = ["describe", "查看用户", 3030101]
teamCreate = ["create", "创建用户", 3030102]
teamEdit = ["edit", "编辑用户", 3030103]
teamDelete = ["delete", "删除用户", 3030104]

teamScheduleModel = ["module", "排班", 3030200]
teamScheduleDescribe = ["describe", "查看排班", 3030201]
teamScheduleCreate = ["create", "创建排班", 3030202]
teamScheduleEdit = ["edit", "编辑排班", 3030203]
teamScheduleDelete = ["delete", "删除排班", 3030204]

taskHandoverModel = ["module", "交接班", 3030300]
taskHandoverDescribe = ["describe", "查看交接班", 3030301]
taskHandoverCreate = ["create", "创建交接班", 3030302]
taskHandoverEdit = ["edit", "编辑交接班", 3030303]
taskHandoverDelete = ["delete", "删除交接班", 3030304]

businessManageModel = ["module", "业务管理", 3040000]
materielModel = ["module", "物料管理", 3040100]
materielDescribe = ["describe", "查看物料物料", 3040101]
materielCreate = ["create", "创建物料", 3040102]
materielEdit = ["edit", "编辑物料", 3040103]
materielDelete = ["delete", "删除物料", 3040104]

taskModel = ["module", "任务管理", 3040200]
taskDescribe = ["describe", "查看任务", 3040201]
taskCreate = ["create", "任务创建任务", 3040202]
taskEdit = ["edit", "编辑任务", 3040203]
taskDelete = ["delete", "任务删除任务", 3040204]

orderModel = ["module", "工单管理", 3040300]
orderDescribe = ["describe", "查看工单", 3040301]
orderCreate = ["create", "创建工单", 3040302]
orderEdit = ["edit", "编辑工单", 3040303]
orderDelete = ["delete", "删除工单", 3040304]

reportManageModel = ["module", "客户报告管理", 3050000]
reportModel = ["module", "客户报告", 3050100]
reportDescribe = ["describe", "查看客户报告", 3050101]
reportCreate = ["create", "创建客户报告", 3050102]
reportEdit = ["edit", "编辑客户报告", 3050103]
reportDelete = ["delete", "删除客户报告", 3050104]

assetManageModel = ["module", "资产管理", 3060000]
assetModel = ["module", "资产管理", 3060100]
assetDescribe = ["describe", "查看资产", 3060101]
assetCreate = ["create", "创建资产", 3060102]
assetEdit = ["edit", "编辑资产", 3060103]
assetDelete = ["delete", "删除资产", 3060104]


screenModel = ["module", "大屏", 4000000]

CRMPlatform = ["module", "CRM平台", 5000000]
CRMCustomerManageModel = ["module", "CRM客户管理", 5010000]
CRMCustomerModel = ["module", "CRM客户列表", 5010100]
CRMCustomerDescribe = ["describe", "查看CRM客户", 5010101]
CRMCustomerCreate = ["create", "创建CRM客户", 5010102]
CRMCustomerEdit = ["edit", "编辑CRM客户", 5010103]
CRMCustomerDelete = ["delete", "删除CRM客户", 5010104]
CRMCustomerDistribution = ["distribution", "CRM客户分配", 5010105]

CRMCustomerClueModel = ["module", "CRM客户线索列表", 5010200]
CRMCustomerClueDescribe = ["describe", "查看CRM客户线索", 5010201]
CRMCustomerClueCreate = ["create", "创建CRM客户线索", 5010202]
CRMCustomerClueEdit = ["edit", "编辑CRM客户线索", 5010203]
CRMCustomerClueDelete = ["delete", "删除CRM客户线索", 5010204]
CRMCustomerClueApprove = ["approve", "CRM客户线索审批", 5010205]

CRMCustomerPortraitModel = ["module", "CRM客户画像列表", 5010300]
CRMCustomerPortraitDescribe = ["describe", "查看CRM客户画像", 5010301]
CRMCustomerPortraitCreate = ["create", "创建CRM客户画像", 5010302]
CRMCustomerPortraitEdit = ["edit", "编辑CRM客户画像", 5010303]
CRMCustomerPortraitDelete = ["delete", "删除CRM客户画像", 5010304]

CRMTaskManageModel = ["module", "CRM任务管理", 5020000]
CRMTaskModel = ["module", "CRM任务列表", 5020100]
CRMTaskDescribe = ["describe", "查看CRM任务", 5020101]
CRMTaskCreate = ["create", "创建CRM任务", 5020102]
CRMTaskEdit = ["edit", "编辑CRM任务", 5020103]
CRMTaskDelete = ["delete", "删除CRM任务", 5020104]
CRMTaskApprove = ["approve", "CRM任务审批", 5020105]

CRMTaskApproveModel = ["module", "CRM任务审批", 5020200]
CRMTaskApproveDescribe = ["describe", "查看CRM任务审批", 5020201]
CRMTaskApproveCreate = ["create", "创建CRM任务审批", 5020202]
CRMTaskApproveEdit = ["edit", "编辑CRM任务审批", 5020203]
CRMTaskApproveDelete = ["delete", "删除CRM任务审批", 5020204]

CRMStatisticsModel = ["module", "CRM统计任务审批", 5030000]
CRMConversionRateModel = ["module", "CRM转化率", 5030100]
CRMConversionRateDescribe = ["describe", "查看CRM转化率", 5030101]
CRMConversionRateCreate = ["create", "创建CRM转化率", 5030102]
CRMConversionRateEdit = ["edit", "编辑CRM转化率", 5030103]
CRMConversionRateDelete = ["delete", "删除CRM转化率", 5030104]

CRMSaleDataModel = ["module", "CRM销售数据管理", 5030200]
CRMSaleDataDescribe = ["describe", "查看CRM销售数据", 5030201]
CRMSaleDataCreate = ["create", "创建CRM销售数据", 5030202]
CRMSaleDataEdit = ["edit", "编辑CRM销售数据", 5030203]
CRMSaleDataDelete = ["delete", "删除CRM销售数据", 5030204]

CRMSaleClueModel = ["module", "CRM销售线索", 5030300]
CRMSaleClueDescribe = ["describe", "查看CRM销售线索", 5030301]
CRMSaleClueCreate = ["create", "创建CRM销售线索", 5030302]
CRMSaleClueEdit = ["edit", "编辑CRM销售线索", 5030303]
CRMSaleClueDelete = ["delete", "删除CRM销售线索", 5030304]

CRMSaleUserManageModel = ["module", "CRM销售人员管理", 5040000]
CRMSaleUserModel = ["module", "CRM销售人员", 5040100]
CRMSaleUserDescribe = ["describe", "查看CRM销售人员", 5040101]
CRMSaleUserCreate = ["create", "创建CRM销售人员", 5040102]
CRMSaleUserEdit = ["edit", "编辑CRM销售人员", 5040103]
CRMSaleUserDelete = ["delete", "删除CRM销售人员", 5040104]

CRMClockInModel = ["module", "CRM人员打卡管理", 5040200]
CRMClockInDescribe = ["describe", "查看CRM人员打卡", 5040201]
CRMClockInCreate = ["create", "创建CRM人员打卡", 5040202]
CRMClockInEdit = ["edit", "编辑CRM人员打卡", 5040203]
CRMClockInDelete = ["delete", "删除CRM人员打卡", 5040204]

CRMCustomerMessageModel = ["module", "CRM客户消息通知", 5040300]
CRMCustomerMessageDescribe = ["describe", "查看CRM客户消息通知", 5040301]
CRMCustomerMessageCreate = ["create", "创建CRM客户消息通知", 5040302]
CRMCustomerMessageEdit = ["edit", "编辑CRM客户消息通知", 5040303]
CRMCustomerMessageDelete = ["delete", "删除CRM客户消息通知", 5040304]

# screenDashboardModel = ["module", "大屏面板", 4010000]
# screenDashboardDescribe = ["describe", "查看大屏面板", 4010101]
# screenDashboardCreate = ["create", "创建大屏面板", 4010102]
# screenDashboardEdit = ["edit", "编辑大屏面板", 4010103]
# screenDashboardDelete = ["delete", "删除大屏面板", 4010104]

CONFIG = {
    "basicDataPlatform": {
        "perms": [
            basicDataPlatform,
        ],
        "sub": {
            "customerInformationModel": {
                "perms": [
                    customerInformationModel
                ],
                "sub": {
                    "customerModel": {
                        "perms": [
                            customerModel,
                            customerDescribe,
                            customerCreate,
                            customerEdit,
                            customerDelete
                        ],
                        "sub": {}
                    },
                    "numberModel": {
                        "perms": [
                            numberModel,
                            numberDescribe,
                            numberCreate,
                            numberEdit,
                            numberDelete,
                        ],
                        "sub": {}
                    },
                    "powerStationModel": {
                        "perms": [
                            powerStationModel,
                            powerStationDescribe,
                            powerStationCreate,
                            powerStationEdit,
                            powerStationDelete,
                        ],
                        "sub": {}
                    },
                    "contractModel": {
                        "perms": [
                            contractModel,
                            contractDescribe,
                            contractCreate,
                            contractEdit,
                            contractDelete,
                        ],
                        "sub": {}
                    }
                }
            },
            "carManageModel": {
                "perms": [
                    carManageModel
                ],
                "sub": {
                    "carInfoModel": {
                        "perms": [
                            carInfoModel,
                            carInfoDescribe,
                            carInfoCreate,
                            carInfoEdit,
                            carInfoDelete,
                        ],
                        "sub": {}
                    }
                }
            },
            "systemModel": {
                "perms": [
                    systemModel
                ],
                "sub": {
                    "userModel": {
                        "perms": [
                            userModel,
                            userDescribe,
                            userCreate,
                            userEdit,
                            userDelete,
                        ],
                        "sub": {}
                    },
                    "roleModel": {
                        "perms": [
                            roleModel,
                            roleDescribe,
                            roleCreate,
                            roleEdit,
                            roleDelete,
                        ],
                        "sub": {}
                    },
                    "organizationModel": {
                        "perms": [
                            organizationModel,
                            organizationDescribe,
                            organizationCreate,
                            organizationEdit,
                            organizationDelete,
                        ],
                        "sub": {}
                    },
                    "messageModel": {
                        "perms": [
                            messageModel,
                            messageDescribe,
                            messageCreate,
                            messageEdit,
                            messageDelete
                        ],
                        "sub": {}
                    },
                    "dictionaryModel": {
                        "perms": [
                            dictionaryModel,
                            dictionaryDescribe,
                            dictionaryCreate,
                            dictionaryEdit,
                            dictionaryDelete,
                        ],
                        "sub": {}
                    },
                    "sysMonitorModel": {
                        "perms": [
                            sysMonitorModel,
                            sysMonitorDescribe,
                            sysMonitorCreate,
                            sysMonitorEdit,
                            sysMonitorDelete,
                        ],
                        "sub": {}
                    },
                    "operationRecordModel": {
                        "perms": [
                            operationRecordModel,
                            operationRecordDescribe,
                            operationRecordCreate,
                            operationRecordEdit,
                            operationRecordDelete,
                        ],
                        "sub": {}
                    },
                }
            },
        },
    },
    "IOTPlatform": {
        "perms": [
            IOTPlatform,
        ],
        "sub": {
            "powerMonitorManageModel": {
                "perms": [
                    powerMonitorManageModel,
                ],
                "sub":{
                    "monitorApprovalModel": {
                        "perms": [
                            monitorApprovalModel,
                            monitorApprovalDescribe,
                            monitorApprovalCreate,
                            monitorApprovalEdit,
                            monitorApprovalDelete
                        ],
                        "sub": {}
                    },
                    "monitorPointManageModel": {
                        "perms": [
                            monitorPointManageModel,
                            monitorPointManageDescribe,
                            monitorPointManageCreate,
                            monitorPointManageEdit,
                            monitorPointManageDelete
                        ],
                        "sub": {}
                    },
                    "monitorDevicesModel": {
                        "perms": [
                            monitorDevicesModel,
                            monitorDevicesDescribe,
                            monitorDevicesCreate,
                            monitorDevicesEdit,
                            monitorDevicesDelete
                        ],
                        "sub": {}
                    },
                    "alarmTemplateModel": {
                        "perms": [
                            alarmTemplateModel,
                            alarmTemplateDescribe,
                            alarmTemplateCreate,
                            alarmTemplateEdit,
                            alarmTemplateDelete
                        ],
                        "sub": {},
                    },
                    "alarmRecordModel": {
                        "perms": [
                            alarmRecordModel,
                            alarmRecordDescribe,
                            alarmRecordCreate,
                            alarmRecordEdit,
                            alarmRecordDelete,
                        ],
                        "sub": {}
                    },
                }
            },
            "ICCIDManageModel": {
                "perms": [
                    ICCIDManageModel,
                ],
                "sub": {
                    "ICCIDModel": {
                        "perms": [
                            ICCIDModel,
                            ICCIDDescribe,
                            ICCIDCreate,
                            ICCIDEdit,
                            ICCIDDelete
                        ],
                        "sub": {}
                    }
                }
            },
            "monitorVideoManageModel": {
                "perms": [
                    monitorVideoManageModel
                ],
                "sub": {
                    "monitorVideoModel": {
                        "perms": [
                            monitorVideoModel,
                            monitorVideoDescribe,
                            monitorVideoCreate,
                            monitorVideoEdit,
                            monitorVideoDelete
                        ],
                        "sub": {}
                    }
                }
            },
            "inspectionRobotManageModel": {
                "perms": [
                    inspectionRobotManageModel
                ],
                "sub": {
                    "inspectionRobotModel": {
                        "perms": [
                            inspectionRobotModel,
                            inspectionRobotDescribe,
                            inspectionRobotCreate,
                            inspectionRobotEdit,
                            inspectionRobotDelete,
                        ],
                        "sub": {}
                    },
                }
            },
            "otherIOTDevicesManageModel": {
                "perms": [
                    otherIOTDevicesManageModel
                ],
                "sub": {
                    "otherIOTDevicesModel": {
                        "perms": [
                            otherIOTDevicesModel,
                            otherIOTDevicesDescribe,
                            otherIOTDevicesCreate,
                            otherIOTDevicesEdit,
                            otherIOTDevicesDelete,
                        ],
                        "sub": {}
                    }
                }
            },
        },
    },
    "businessPlatform": {
        "perms": [
            businessPlatform,
        ],
        "sub": {
            "trusteeshipCustomerManageModel": {
                "perms": [
                    trusteeshipCustomerManageModel
                ],
                "sub": {
                    "trusteeshipCustomerModel": {
                        "perms": [
                            trusteeshipCustomerModel,
                            trusteeshipCustomerDescribe,
                            trusteeshipCustomerCreate,
                            trusteeshipCustomerEdit,
                            trusteeshipCustomerDelete
                        ],
                        "sub": {}
                    }
                }
            },
            "inspectionOperationManageModel": {
                "perms": [
                    inspectionOperationManageModel
                ],
                "sub": {
                    "inspectionPlanModel": {
                        "perms": [
                            inspectionPlanModel,
                            inspectionPlanDescribe,
                            inspectionPlanCreate,
                            inspectionPlanEdit,
                            inspectionPlanDelete
                        ],
                        "sub": {}
                    },
                    "inspectionTaskModel": {
                        "perms": [
                            inspectionTaskModel,
                            inspectionTaskDescribe,
                            inspectionTaskCreate,
                            inspectionTaskEdit,
                            inspectionTaskDelete
                        ],
                        "sub": {}
                    },
                    "inspectionRecordModel": {
                        "perms": [
                            inspectionRecordModel,
                            inspectionRecordDescribe,
                            inspectionRecordCreate,
                            inspectionRecordEdit,
                            inspectionRecordDelete
                        ],
                        "sub": {}
                    },
                    "defectModel": {
                        "perms": [
                            defectModel,
                            defectDescribe,
                            defectCreate,
                            defectEdit,
                            defectDelete,
                        ],
                        "sub": {}
                    }
                }
            },
            "teamManageModel": {
                "perms": [
                    teamManageModel
                ],
                "sub": {
                    "teamModel": {
                        "perms": [
                            teamModel,
                            teamDescribe,
                            teamCreate,
                            teamEdit,
                            teamDelete
                        ],
                        "sub": {}
                    },
                    "teamScheduleModel": {
                        "perms": [
                            teamScheduleModel,
                            teamScheduleDescribe,
                            teamScheduleCreate,
                            teamScheduleEdit,
                            teamScheduleDelete
                        ],
                        "sub": {}
                    },
                    "taskHandoverModel": {
                        "perms": [
                            taskHandoverModel,
                            taskHandoverDescribe,
                            taskHandoverCreate,
                            taskHandoverEdit,
                            taskHandoverDelete
                        ],
                        "sub": {}
                    }
                }
            },
            "businessManageModel": {
                "perms": [
                    businessManageModel
                ],
                "sub": {
                    "materielModel": {
                        "perms": [
                            materielModel,
                            materielDescribe,
                            materielCreate,
                            materielEdit,
                            materielDelete
                        ],
                        "sub": {}
                    },
                    "taskModel": {
                        "perms": [
                            taskModel,
                            taskDescribe,
                            taskCreate,
                            taskEdit,
                            taskDelete
                        ],
                        "sub": {}
                    },
                    "orderModel": {
                        "perms": [
                            orderModel,
                            orderDescribe,
                            orderCreate,
                            orderEdit,
                            orderDelete
                        ],
                        "sub": {},
                    }
                }
            },
            "reportManageModel": {
                "perms": [
                    reportManageModel
                ],
                "sub": {
                    "reportModel": {
                        "perms": [
                            reportModel,
                            reportDescribe,
                            reportCreate,
                            reportEdit,
                            reportDelete
                        ]
                    }
                }
            },
            "assetManageModel": {
                "perms": [
                    assetManageModel
                ],
                "sub": {
                    "assetModel": {
                        "perms": [
                            assetModel,
                            assetDescribe,
                            assetCreate,
                            assetEdit,
                            assetDelete
                        ],
                        "sub": {}
                    }
                }
            }
        }
    },
    "screenModel": {
        "perms": [
            screenModel
        ],
        "sub": {}
    },
    "CRMPlatform": {
        "perms": [
            CRMPlatform,
        ],
        "sub": {
            "CRMCustomerManageModel":{
                "perms":[
                    CRMCustomerManageModel,
                ],
                "sub":{
                    "CRMCustomerModel": {
                        "perms": [
                            CRMCustomerModel,
                            CRMCustomerDescribe,
                            CRMCustomerCreate,
                            CRMCustomerEdit,
                            CRMCustomerDelete,
                            CRMCustomerDistribution,
                        ],
                        "sub": {}
                    },
                    "CRMCustomerClueModel": {
                        "perms": [
                            CRMCustomerClueModel,
                            CRMCustomerClueDescribe,
                            CRMCustomerClueCreate,
                            CRMCustomerClueEdit,
                            CRMCustomerClueDelete,
                            CRMCustomerClueApprove,
                        ],
                        "sub": {}
                    },
                    "CRMCustomerPortraitModel": {
                        "perms": [
                            CRMCustomerPortraitModel,
                            CRMCustomerPortraitDescribe,
                            CRMCustomerPortraitCreate,
                            CRMCustomerPortraitEdit,
                            CRMCustomerPortraitDelete,
                        ],
                        "sub": {}
                    },
                }
            },
            "CRMTaskManageModel":{
                "perms":[
                    CRMTaskManageModel,
                ],
                "sub": {
                    "CRMTaskModel": {
                        "perms":[
                            CRMTaskModel,
                            CRMTaskDescribe,
                            CRMTaskCreate,
                            CRMTaskEdit,
                            CRMTaskDelete,
                            CRMTaskApprove,
                        ],
                        "sub": {}
                    },
                    "CRMTaskApproveModel": {
                        "perms": [
                            CRMTaskApproveModel,
                            CRMTaskApproveDescribe,
                            CRMTaskApproveCreate,
                            CRMTaskApproveEdit,
                            CRMTaskApproveDelete,
                        ],
                        "sub": {}
                    },
                }
            },
            "CRMStatisticsModel":{
                "perms":[
                    CRMStatisticsModel,
                ],
                "sub": {
                    "CRMConversionRateModel": {
                        "perms":[
                            CRMConversionRateModel,
                            CRMConversionRateDescribe,
                            CRMConversionRateCreate,
                            CRMConversionRateEdit,
                            CRMConversionRateDelete,
                        ],
                        "sub": {}
                    },
                    "CRMSaleDataModel": {
                        "perms": [
                            CRMSaleDataModel,
                            CRMSaleDataDescribe,
                            CRMSaleDataCreate,
                            CRMSaleDataEdit,
                            CRMSaleDataDelete,
                        ],
                        "sub": {}
                    },
                    "CRMSaleClueModel": {
                        "perms": [
                            CRMSaleClueModel,
                            CRMSaleClueDescribe,
                            CRMSaleClueCreate,
                            CRMSaleClueEdit,
                            CRMSaleClueDelete,
                        ],
                        "sub": {}
                    },

                }
            },
            "CRMSaleUserManageModel":{
                "perms":[
                    CRMSaleUserManageModel,
                ],
                "sub": {
                    "CRMSaleUserModel": {
                        "perms":[
                            CRMSaleUserModel,
                            CRMSaleUserDescribe,
                            CRMSaleUserCreate,
                            CRMSaleUserEdit,
                            CRMSaleUserDelete,
                        ],
                        "sub": {}
                    },
                    "CRMClockInModel": {
                        "perms": [
                            CRMClockInModel,
                            CRMClockInDescribe,
                            CRMClockInCreate,
                            CRMClockInEdit,
                            CRMClockInDelete,
                        ],
                        "sub": {}
                    },
                    "CRMCustomerMessageModel": {
                        "perms": [
                            CRMCustomerMessageModel,
                            CRMCustomerMessageDescribe,
                            CRMCustomerMessageCreate,
                            CRMCustomerMessageEdit,
                            CRMCustomerMessageDelete,
                        ],
                        "sub": {}
                    },

                }
            }
        }
    }
}

DEFAULT_ROLES_PERMS = {
    "系统管理员": [],
    "客户": [],
}


# 权限配置转化为通用数据结构
def perms_tree(config: Dict) -> Dict:
    rst = {}
    for k, v in config.items():
        if k == "perms":
            rst.setdefault(k, {})
            for i in v:
                rst[k].update({i[0]: True})
        if k == "sub":
            rst.setdefault(k, {})
            for i, j in perms_tree(v).items():
                rst[k].update({i: j})
        elif isinstance(v, dict):
            rst.setdefault(k, {})
            rst[k].update(perms_tree(v))
    return rst


# 权限配置转化为前端数据结构
def json_perms(config):
    service = {}
    rst = []
    for k, v in config.items():
        serv = {}
        if k == "perms":
            service.setdefault(k, [])
            for i in v:
                service[k].append({i[0]: False})
        if k == "sub":
            service.setdefault(k, {})
            s, r = json_perms(v)
            service[k] = r
        elif isinstance(v, dict):
            serv.update({"service": k})
            s, r = json_perms(v)
            serv.update(s)
        rst.append(serv)
    return service, rst


def union_perms_to_json(config, perms_list):
    service = {}
    rst = []
    for k, v in config.items():
        serv = {}
        if k == "perms":
            service.setdefault(k, [])
            for i in v:
                if i[2] in perms_list:
                    service[k].append({i[0]: True})
                else:
                    service[k].append({i[0]: False})
        if k == "sub":
            service.setdefault(k, {})
            s, r = union_perms_to_json(v, perms_list)
            service[k] = r
        elif isinstance(v, dict):
            serv.update({"service": k})
            s, r = union_perms_to_json(v, perms_list)
            serv.update(s)
        rst.append(serv)
    return service, rst


def union_perms_to_json_v2(config, perms_list):
    rst = {}
    for k, v in config.items():
        if k == "perms":
            rst.setdefault(k, {})
            for i in v:
                if i[2] in perms_list:
                    rst[k].update({i[0]: True})
                else:
                    rst[k].update({i[0]: False})
        if k == "sub":
            rst.setdefault(k, {})
            for i, j in union_perms_to_json_v2(v, perms_list).items():
                rst[k].update({i: j})
        elif isinstance(v, dict):
            rst.setdefault(k, {})
            rst[k].update(union_perms_to_json_v2(v, perms_list))
    return rst


# 权限配置转化为数据库数据结构
def model_perms(config, key=None, kind=None):
    rst = []
    for k, v in config.items():
        if k == "perms":
            for i in v:
                name = [key, i[0]] if key else [i[0]]
                rst.append({
                    "name": '_'.join(name),
                    "desc": i[1],
                    "code": i[2],
                    "group": key,
                    "kind": kind,
                })
        if k == "sub":
            rst.extend(model_perms(v, key=k, kind=kind))
        elif isinstance(v, dict):
            if kind is None:
                rst.extend(model_perms(v, key=k, kind=k))
            else:
                rst.extend(model_perms(v, key=k, kind=kind))
    return rst

# print(model_perms(CONFIG))
# print(json.dumps(json_perms_v2(CONFIG)))
# print(json.dumps(perms_tree(CONFIG)))
# print(json.dumps(union_perms_to_json_v2(CONFIG, [100000])))

# UsersLCView = {
#     "__message": {
#         "get": {
#             "perms": [100101],
#             "operation": None,
#         },
#         "post": {
#             "perms": [100102],
#             "operation": "创建用户"
#         },
#         "put": {
#             "perms": [100103],
#             "operation": None,
#         },
#         "delete": {
#             "perms": [100104],
#             "operation": None,
#         }
#     }
# }
#
# UsersSearchView = {
#     "__message": {
#         "get": {
#             "perms": [100101],
#             "operation": None,
#         },
#         "post": {
#             "perms": [],
#             "operation": None,
#         },
#         "put": {
#             "perms": [],
#             "operation": None,
#         },
#         "delete": {
#             "perms": [],
#             "operation": None,
#         }
#     }
# }
#
# UsersRUDView = {
#     "__message": {
#         "get": {
#             "perms": [100101],
#             "operation": None,
#         },
#         "post": {
#             "perms": [100102],
#             "operation": None,
#         },
#         "put": {
#             "perms": [100103],
#             "operation": "编辑用户"
#         },
#         "delete": {
#             "perms": [100104],
#             "operation": "删除用户"
#         }
#     }
# }
#
# RolesLCView = {
#     "__message": {
#         "get": {
#             "perms": [100201],
#             "operation": None,
#         },
#         "post": {
#             "perms": [100202],
#             "operation": "创建角色"
#         },
#         "put": {
#             "perms": [100203],
#             "operation": "编辑角色"
#         },
#         "delete": {
#             "perms": [100204],
#             "operation": "删除角色"
#         }
#     }
# }
#
# RolesRUDView = {
#     "__message": {
#         "get": {
#             "perms": [100201],
#             "operation": None,
#         },
#         "post": {
#             "perms": [100202],
#             "operation": None,
#         },
#         "put": {
#             "perms": [100203],
#             "operation": "编辑角色"
#         },
#         "delete": {
#             "perms": [100204],
#             "operation": "删除角色"
#         }
#     }
# }
#
# UsersRolesMultiLCView = {
#     "__message": {
#         "get": {
#             "perms": [100201],
#             "operation": None,
#         },
#         "post": {
#             "perms": [100202],
#             "operation": "批量创建角色"
#         },
#         "put": {
#             "perms": [100203],
#             "operation": "编辑角色"
#         },
#         "delete": {
#             "perms": [100204],
#             "operation": "删除角色"
#         }
#     }
# }
