import abc
from functools import wraps
import requests

session = requests.Session()
adapter = requests.adapters.HTTPAdapter(pool_connections=10,
                                        pool_maxsize=100,
                                        max_retries=3)
session.mount("http://", adapter)
session.mount("https://", adapter)


class ApiAuthenticationError(Exception):
    def __init__(self):
        pass


def checkAuthentication(func):
    @wraps(func)
    def wrapper(self, *args, **kwargs):
        try:
            return func(self, *args, **kwargs)
        except ApiAuthenticationError:
            self.set_access_token()
            return func(self, *args, **kwargs)

    return wrapper


class BaseConfiguration(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def request(self, *args, **kwargs):
        raise

    @abc.abstractmethod
    def set_access_token(self):
        raise


class Surveillance(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def list_cameras(self):
        raise

    @abc.abstractmethod
    def camera_info(self):
        raise

    @abc.abstractmethod
    def camera_status(self):
        raise

    @abc.abstractmethod
    def live_stream(self):
        raise

    @abc.abstractmethod
    def playback_stream(self):
        raise

    @abc.abstractmethod
    def list_account(self):
        raise
