# -*- coding=utf-8 -*-
from qcloud_cos import CosS3Client
from django.conf import settings
from urllib import parse


class COSClient(CosS3Client):
    def __init__(self, conf, retry=1, session=None):
        super(COSClient, self).__init__(conf, retry=retry, session=session)

    def delete_object_by_url(self, url, **kwargs):
        url_data = parse.urlparse(url)
        Bucket = url_data.netloc.split(".")[0]
        Key = url_data.path.strip("/")
        self.delete_object(Bucket, Key, **kwargs)


cos_client = COSClient(settings.Q_CLOUD_CONFIG)
