from django.db import models

# Create your models here.
from common.utils.models import BaseModel


class Form(BaseModel):
    table = models.CharField(max_length=32, help_text="表名", unique=True)
    name = models.CharField(max_length=32,
                            null=True,
                            blank=True,
                            help_text="表名释义")

    class Meta:
        db_table = "form"


class FormAttribute(BaseModel):
    form = models.ForeignKey(to=Form,
                             on_delete=models.SET_NULL,
                             null=True,
                             help_text="所属表单")
    attribute = models.CharField(max_length=32, help_text="表字段")
    data_type = models.CharField(max_length=32, help_text="数据类型")
    explain = models.CharField(max_length=64,
                               null=True,
                               blank=True,
                               help_text="字段释义")

    class Meta:
        db_table = 'form_attribute'
