#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.urls import path

from . import views

urlpatterns = [
    path(r'login', views.JWTTokenView.as_view(), name='login'),
    path(r'logout', views.LogoutView.as_view(), name='logout'),
    path(r'<int:id>/password/',
         views.SetPassword.as_view(),
         name='SetPassword'),
    path("console/users", views.UsersLCView.as_view()),
    path("console/users/search", views.UsersSearchView.as_view()),
    path("console/users/<int:user_id>", views.UsersRUDView.as_view()),
    path("console/users/<int:user_id>/password", views.PasswordUView.as_view()),
    # 新
    path("console/user", views.UserLCView.as_view()),
    path("console/user/<int:user_id>", views.UserRUDView.as_view()),
    path("console/user_center/info", views.UserCenterRUDView.as_view()),
    path("console/user_center/password", views.UserCenterSetPassword.as_view()),

    path("console/roles", views.RolesLCView.as_view()),
    path("console/roles/<int:role_id>", views.RolesRUDView.as_view()),
    path("console/users/<int:user_id>/roles",
         views.UsersRolesMultiLCView.as_view()),
    path("console/tags", views.TagsLCView.as_view()),
    path("console/tags/<int:tag_id>", views.TagsRUDView.as_view()),
    path("console/tags/<int:tag_id>/users", views.TagUsersLView.as_view()),
    path("console/users/<int:user_id>/tags", views.UserTagsLCView.as_view()),
    path("console/perms", views.PermsLView.as_view()),
    path("console/roles/<int:role_id>/perms", views.RolePermsLCView.as_view()),
]
