#!/usr/bin/env python
# -*- coding: utf-8 -*-
from django_filters import rest_framework as filters

from common.accounts.models import Roles, UserRoles, Tags


class UsersLFilter(filters.FilterSet):
    # enterprise_id = filters.CharFilter(method="get_enterprise")
    user_id = filters.CharFilter(method="get_user")

    # def get_enterprise(self, queryset, name, value):
    #     queryset = queryset.prefetch_related("ent_user").filter(
    #         ent_user__deleted=False, ent_user__enterprise=value)
    #     return queryset

    def get_user(self, queryset, _, value):
        queryset = queryset.filter(id=value)
        return queryset


class RolesFilter(filters.FilterSet):
    name = filters.CharFilter(field_name='name',
                              label='name',
                              lookup_expr='contains',
                              help_text='通过角色名称查找')

    class Meta:
        model = Roles
        fields = ('name', )


class UserRolesFilter(filters.FilterSet):
    class Meta:
        model = UserRoles
        fields = ('user_id', )


class TagsFilter(filters.FilterSet):
    name = filters.CharFilter(field_name='name',
                              label='name',
                              lookup_expr='contains',
                              help_text='通过标签名称查找')

    class Meta:
        model = Tags
        fields = ('name', )
