#! /bin/bash

# check code
echo "start check code specification by flake8"
flake8 --exclude env,venv,static,etc,etl,industrial_gateway,manage.py,production_manage.py,migrations,deploy,mysql --extend-ignore=W605 --max-line-length 79 ./src/backend/
if [ $? -ne 0 ]; then
    exit 1
fi
echo "check code specification success"
# check code format
echo "start check code style by yapf"
yapf --exclude env --exclude venv --exclude git --exclude industrial_gateway --exclude etl --exclude static --exclude mysql --style ./src/backend/yapf_style.cfg  -r ./src/backend/ -i
git status -s
[[ -z $(git status -s | grep -v venv| grep -v git) ]] || { echo "some code do not format before commit, please run 'make format' before git commit"; exit 1;}
echo "check code style success"
exit 0
