#!/bin/bash
set -e


path="/opt/etl/cycle_jobs"
if [[ ! -d $path ]];then
   echo "####################$path is not exist#########"
   exit 1
fi

noExecJob=$NOEXECJOB
execJob=$EXECJOB
files=`ls $path`
echo "datax job list: $files"
if [[ $files != "" ]]; then 
   current=`date "+%Y-%m-%d %H:%M:%S"`
   timeStamp=`date -d "$current" +%s` 
   echo "##################recond start time: $timeStamp ####################"
   echo $timeStamp>/starttime
   echo "##################datax jobs####################"
   if [[ $EXECJOB != "" ]]; then
      echo "##################exec data job: $EXECJOB"
      datax start $path"/"$EXECJOB
   else
      for file in $files
      do  
          if [[ $noExecJob == $file ]]; then
	     echo "##############jump over $noExecJob#######"
	     continue
          fi
          echo "#################exec datax job: $file"
          datax start $path"/"$file
      done
   fi
else
   echo "###############no datax jobs####################"
   exit 1
fi   
