import user_agents
from django.urls import include
from django.conf.urls import url
from django.shortcuts import redirect
from rest_framework import permissions
from drf_yasg.views import get_schema_view
from drf_yasg import openapi

swagger_info = openapi.Info(
    title="电管家数据平台 API",
    default_version='v1',
    description="""
    # 电管家数据平台协议
    ## 协议描述
    本协议基于http 的web api接口实现，通过post方式提交参数，返回json格式的监控数据。
    
    ## URL示例
    ``` http
    http://monitor.ampbyte.com.cn/api/v1/{厂商}/{设备型号}
    ```
    ## 数据验证
    
    **验证算法**
    
    "dgj" + sn(设备imei号) + "xxxxx" ，取32位MD5，截取32位结果字符串的9-24位字符串。
    
    **示例**
    ``` python
    # python 示例
    import hashlib

    a = {
        "imei": "asdxs0200064210",
        "data": {
                    "ua": 220.11,
                    "ub": 220.11,
                    "uc": 220.11,
                    "ia": 11.01,
                    "ib": 12.01,
                    "ic": 13.01,
                    "pa": 123.001,
                    "pb": 133.001,
                    "pc": 103.001,
                    "psum": 103.001,
                    "qa": 124.001,
                    "qb": 134.001,
                    "qc": 104.001,
                    "qsum": 204.001,
                    "pfa": 0.981,
                    "pfb": 0.971,
                    "pfc": 0.991,
                    "pfsum": 0.981,
                    "fr": 50.01,
                    "px": 50.001,
                    "ep": 50.001,
                    "eq1": 50.001,
                    "eq2": 50.001,
                    "udis":3.2,
                    "idis":12.5,
                    "uah": 2.1,
                    "ubh": 2.3,
                    "uch": 3.6,
                    "iah": 1.2,
                    "ibh": 2.01,
                    "ich": 3.001,
                    "tc": 24.1
        },
        "t": 24,
        "s": 12,
        "v": "124b1bc06ca740b3"
    }
    sn = a["imei"]
    dt = "dgj" + sn + "cet"
    dt_md5= hashlib.md5(dt.encode()).hexdigest()
    print(dt_md5[8:24])
    ```
    """,
    terms_of_service="https://www.google.com/policies/terms/",
    contact=openapi.Contact(email="contact@snippets.local"),
    license=openapi.License(name="BSD License"),
)

SchemaView = get_schema_view(
    public=True,
    permission_classes=(permissions.AllowAny, ),
)


def root_redirect(request):
    user_agent_string = request.META.get('HTTP_USER_AGENT', '')
    user_agent = user_agents.parse(user_agent_string)

    if user_agent.is_mobile:
        schema_view = 'cschema-redoc'
    else:
        schema_view = 'cschema-swagger-ui'

    return redirect(schema_view, permanent=True)


urlpatterns = []

urlpatterns += [
    url(r'^swagger(?P<format>.json|.yaml)$',
        SchemaView.without_ui(cache_timeout=0),
        name='schema-json'),
    url(r'^swagger/$',
        SchemaView.with_ui('swagger', cache_timeout=0),
        name='schema-swagger-ui'),
    url(r'^redoc/$',
        SchemaView.with_ui('redoc', cache_timeout=0),
        name='schema-redoc'),
    url(r'^redoc-old/$',
        SchemaView.with_ui('redoc-old', cache_timeout=0),
        name='schema-redoc-old'),
    url(r'^cached/swagger(?P<format>.json|.yaml)$',
        SchemaView.without_ui(cache_timeout=None),
        name='cschema-json'),
    url(r'^cached/swagger/$',
        SchemaView.with_ui('swagger', cache_timeout=None),
        name='cschema-swagger-ui'),
    url(r'^cached/redoc/$',
        SchemaView.with_ui('redoc', cache_timeout=None),
        name='cschema-redoc'),
    url(r'^$', root_redirect),
]

urlpatterns += [url(r'^silk/', include('silk.urls', namespace='silk'))]
