from rest_framework import serializers


class BaseDataV1Serializer(serializers.Serializer):
    ua = serializers.FloatField(allow_null=True, help_text="A相电流")
    ub = serializers.FloatField(allow_null=True, help_text="B相电流")
    uc = serializers.FloatField(allow_null=True, help_text="C相电流")
    ia = serializers.FloatField(allow_null=True, help_text="A相电压")
    ib = serializers.FloatField(allow_null=True, help_text="B相电压")
    ic = serializers.FloatField(allow_null=True, help_text="C相电压")
    pa = serializers.FloatField(allow_null=True, help_text="A相功率")
    pb = serializers.FloatField(allow_null=True, help_text="B相功率")
    pc = serializers.FloatField(allow_null=True, help_text="A相功率")
    psum = serializers.FloatField(allow_null=True, help_text="总功率")

    qa = serializers.FloatField(allow_null=True, help_text="A相无功功率")
    qb = serializers.FloatField(allow_null=True, help_text="B相无功功率")
    qc = serializers.FloatField(allow_null=True, help_text="C相无功功率")
    qsum = serializers.FloatField(allow_null=True, help_text="总无功功率")

    pfa = serializers.FloatField(allow_null=True, help_text="A相功率因数")
    pfb = serializers.FloatField(allow_null=True, help_text="B相功率因数")
    pfc = serializers.FloatField(allow_null=True, help_text="C相功率因数")
    pfsum = serializers.FloatField(allow_null=True, help_text="总功率因数")

    fr = serializers.FloatField(allow_null=True, help_text="频率")
    px = serializers.FloatField(allow_null=True, help_text="有功需量")
    eq1 = serializers.FloatField(allow_null=True, help_text="感性无功")
    eq2 = serializers.FloatField(allow_null=True, help_text="容性无功")
    ep = serializers.FloatField(allow_null=True, help_text="总有功")

    udis = serializers.FloatField(allow_null=True, help_text="不平衡电压百分比")
    idis = serializers.FloatField(allow_null=True, help_text="不平衡电流百分比")
    uah = serializers.FloatField(allow_null=True, help_text="A相总电压谐波畸变率")
    ubh = serializers.FloatField(allow_null=True, help_text="B相总电压谐波畸变率")
    uch = serializers.FloatField(allow_null=True, help_text="C相总电压谐波畸变率")
    iah = serializers.FloatField(allow_null=True, help_text="A相总电流谐波畸变率")
    ibh = serializers.FloatField(allow_null=True, help_text="B相总电流谐波畸变率")
    ich = serializers.FloatField(allow_null=True, help_text="C相总电流谐波畸变率")

    tc = serializers.FloatField(allow_null=True, help_text="线路温度")


class BaseDataV3Serializer(serializers.Serializer):
    """
    A相电压	        ua
    B相电压	        ub
    C相电压	        uc
    AB线电压	        uab
    BC线电压	        ubc
    CA线电压	        uca
    A相电流	        ia
    B相电流	        ib
    C相电流	        ic
    剩余电流	        ir
    A相有功功率	    pa
    B相有功功率	    pb
    C相有功功率	    pc
    总有功功率	    p
    A相无功功率	    qa
    B相无功功率	    qb
    C相无功功率	    qc
    总无功功率	    q
    A相视在功率	    sa
    B相视在功率	    sb
    C相视在功率	    sc
    总视在功率	    s
    A相功率因数	    pfa
    B相功率因数	    pfb
    C相功率因数	    pfc
    总功率因数	    pf
    电源频率	        f
    总有功电能	    ept
    正向无功电能	    eqi
    反向无功电能	    eqe
    总有功功率实时需量	p_d
    三相电压不平衡度	lvur
    三相电流不平衡度	iur
    A相电压总谐波畸变率	ua_thd
    B相电压总谐波畸变率	ub_thd
    C相电压总谐波畸变率	uc_thd
    A相电流总谐波畸变率	ia_thd
    B相电流总谐波畸变率	ib_thd
    C相电流总谐波畸变率	ic_thd
    温度1	        t1
    温度2	        t2
    温度3	        t3
    温度4	        t4

    """
    ua = serializers.FloatField(required=False, allow_null=True, help_text="A相电流")
    ub = serializers.FloatField(required=False, allow_null=True, help_text="B相电流")
    uc = serializers.FloatField(required=False, allow_null=True, help_text="C相电流")

    uab = serializers.FloatField(required=False, allow_null=True, help_text="AB线电压")
    ubc = serializers.FloatField(required=False, allow_null=True, help_text="BC线电压")
    uca = serializers.FloatField(required=False, allow_null=True, help_text="CA线电压")

    ia = serializers.FloatField(required=False, allow_null=True, help_text="A相电流")
    ib = serializers.FloatField(required=False, allow_null=True, help_text="B相电流")
    ic = serializers.FloatField(required=False, allow_null=True, help_text="C相电流")
    ir = serializers.FloatField(required=False, allow_null=True, help_text="剩余电流")

    pa = serializers.FloatField(required=False, allow_null=True, help_text="A相有功功率")
    pb = serializers.FloatField(required=False, allow_null=True, help_text="B相有功功率")
    pc = serializers.FloatField(required=False, allow_null=True, help_text="C相有功功率")
    p = serializers.FloatField(required=False, allow_null=True, help_text="总有功功率")

    qa = serializers.FloatField(required=False, allow_null=True, help_text="A相无功功率")
    qb = serializers.FloatField(required=False, allow_null=True, help_text="B相无功功率")
    qc = serializers.FloatField(required=False, allow_null=True, help_text="C相无功功率")
    q = serializers.FloatField(required=False, allow_null=True, help_text="总无功功率")

    sa = serializers.FloatField(required=False, allow_null=True, help_text="A相视在功率")
    sb = serializers.FloatField(required=False, allow_null=True, help_text="A相视在功率")
    sc = serializers.FloatField(required=False, allow_null=True, help_text="A相视在功率")
    s = serializers.FloatField(required=False, allow_null=True, help_text="A相视在功率")

    pfa = serializers.FloatField(required=False, allow_null=True, help_text="A相功率因数")
    pfb = serializers.FloatField(required=False, allow_null=True, help_text="B相功率因数")
    pfc = serializers.FloatField(required=False, allow_null=True, help_text="C相功率因数")
    pf = serializers.FloatField(required=False, allow_null=True, help_text="总功率因数")

    f = serializers.FloatField(required=False, allow_null=True, help_text="电源频率")

    ept = serializers.FloatField(required=False, allow_null=True, help_text="总有功电能")
    eqi = serializers.FloatField(required=False, allow_null=True, help_text="正向无功电能")
    eqe = serializers.FloatField(required=False, allow_null=True, help_text="反向无功电能")

    p_d = serializers.FloatField(required=False, allow_null=True, help_text="总有功功率实时需量")

    lvur = serializers.FloatField(required=False, allow_null=True, help_text="三相电压不平衡度")
    iur = serializers.FloatField(required=False, allow_null=True, help_text="三相电流不平衡度")

    ua_thd = serializers.FloatField(required=False, allow_null=True, help_text="A相电压总谐波畸变率")
    ub_thd = serializers.FloatField(required=False, allow_null=True, help_text="B相电压总谐波畸变率")
    uc_thd = serializers.FloatField(required=False, allow_null=True, help_text="C相电压总谐波畸变率")

    ia_thd = serializers.FloatField(required=False, allow_null=True, help_text="A相电流总谐波畸变率")
    ib_thd = serializers.FloatField(required=False, allow_null=True, help_text="B相电流总谐波畸变率")
    ic_thd = serializers.FloatField(required=False, allow_null=True, help_text="C相电流总谐波畸变率")

    t1 = serializers.FloatField(required=False, allow_null=True, help_text="温度1")
    t2 = serializers.FloatField(required=False, allow_null=True, help_text="温度2")
    t3 = serializers.FloatField(required=False, allow_null=True, help_text="温度3")
    t4 = serializers.FloatField(required=False, allow_null=True, help_text="温度4")


class BaseDataSerializer(serializers.Serializer):
    pass


class BaseSerializer(serializers.Serializer):
    msg = serializers.CharField(help_text="英文描述")
    msg_show = serializers.CharField(help_text="中文描述")
    code = serializers.IntegerField(help_text="状态码")


def serializer_assembly(instance, many=False):
    if many:
        BaseDataSerializer._declared_fields['bean'] = serializers.DictField()
        BaseDataSerializer._declared_fields['list'] = instance(many=many)
        BaseSerializer._declared_fields['page'] = serializers.IntegerField(
            required=False, help_text="页码")
        BaseSerializer._declared_fields[
            'page_size'] = serializers.IntegerField(required=False,
                                                    help_text="每页数量")
        BaseSerializer._declared_fields['count'] = serializers.IntegerField(
            required=False, help_text="共计")
    else:
        BaseDataSerializer._declared_fields['bean'] = instance()
        BaseDataSerializer._declared_fields['list'] = serializers.ListField()
    BaseSerializer._declared_fields['data'] = BaseDataSerializer()
    return BaseSerializer


class BaseResponesSerializer(serializers.Serializer):
    result = serializers.CharField(default="ok")
