import datetime
import time
import logging

logger = logging.getLogger("")


def getdate(beforeOfDay):
    today = datetime.datetime.now()
    offset = datetime.timedelta(days=-beforeOfDay)
    re_date = (today + offset).strftime('%Y-%m-%d')
    return re_date


def GetRunTime(func):
    def call_func(*args, **kwargs):
        begin_time = time.time()
        ret = func(*args, **kwargs)
        end_time = time.time()
        Run_time = end_time - begin_time
        logger.debug(str(func.__name__) + "函数运行时间为" + str(Run_time))
        return ret

    return call_func
