import hashlib
import re
from decimal import Decimal

mo_map = {
    50: "pa",
    51: "pb",
    52: "pc",
    53: "p",
    54: "qa",
    55: "qb",
    56: "qc",
    57: "q",
    58: "sa",
    59: "sb",
    60: "sc",
    61: "s",
    82: "f",
    83: "ept",
    84: "eqi",
    85: "eqe",
    86: "p_d",
    87: "lvur",
    88: "iur",
    89: "ua_thd",
    90: "ub_thd",
    91: "uc_thd",
    92: "ia_thd",
    93: "ib_thd",
    94: "ic_thd",
    95: "t1",
    96: "t2",
    97: "t3",
    98: "t4"
}
mo_map_bk ={
    0: "ua",
    5: "ub",
    10: "uc",
    15: "uab",
    20: "ubc",
    25: "uca",
    30: "ia",
    35: "ib",
    40: "ic",
    45: "ir",

    62: "pfa",
    67: "pfb",
    72: "pfc",
    77: "pf",
}
mo_map_bk1 ={
    1: "ua",
    6: "ub",
    11: "uc",
    16: "uab",
    21: "ubc",
    26: "uca",
    31: "ia",
    36: "ib",
    41: "ic",
    46: "ir",

    63: "pfa",
    68: "pfb",
    73: "pfc",
    78: "pf",
}
mo_map_bk2 ={
    2: "ua",
    7: "ub",
    12: "uc",
    17: "uab",
    22: "ubc",
    27: "uca",
    32: "ia",
    37: "ib",
    42: "ic",
    47: "ir",

    64: "pfa",
    69: "pfb",
    74: "pfc",
    79: "pf",
}
mo_map_bk3 ={
    3: "ua",
    8: "ub",
    13: "uc",
    18: "uab",
    23: "ubc",
    28: "uca",
    33: "ia",
    38: "ib",
    43: "ic",
    48: "ir",

    65: "pfa",
    70: "pfb",
    75: "pfc",
    80: "pf",
}
mo_map_bk4 ={
    4: "ua",
    9: "ub",
    14: "uc",
    19: "uab",
    24: "ubc",
    29: "uca",
    34: "ia",
    39: "ib",
    44: "ic",
    49: "ir",

    66: "pfa",
    71: "pfb",
    76: "pfc",
    81: "pf",
}


def imei_md5(value, salt):
    dt = "dgj" + value + salt
    dt_md5 = hashlib.md5(dt.encode()).hexdigest()
    return dt_md5[8:24]

encrypt_map = []
encrypt_map.extend([{"bit": 32, "negative": False, "magnification": 0.001, "dc": "0.000"}] * 50)
encrypt_map.extend([{"bit": 32, "negative": True, "magnification": 0.001, "dc": "0.000"}] * 12)
encrypt_map.extend([{"bit": 32, "negative": True, "magnification": 0.001, "dc": "0.000"}] * 20)
encrypt_map.extend([{"bit": 16, "negative": False, "magnification": 0.01, "dc": "0.00"}])
encrypt_map.extend([{"bit": 32, "negative": False, "magnification": 0.1, "dc": "0.0"}] * 3)
encrypt_map.extend([{"bit": 32, "negative": False, "magnification": 0.001, "dc": "0.000"}])
encrypt_map.extend([{"bit": 16, "negative": False, "magnification": 0.01, "dc": "0.00"}] * 8)
encrypt_map.extend([{"bit": 16, "negative": True, "magnification": 0.01, "dc": "0.00"}] * 4)

def signed_int_value(vl, bit=32, negative=False, magnification=1, dc='0'):
    if not negative:
        # Decimal('50.5679').quantize(Decimal('0.00'))
        return Decimal(int(vl, base=16) * magnification).quantize(Decimal(dc))
    else:
        pos_max = 2 ** int(bit-1) - 1
        value = int(vl, base=16)
        if value > pos_max:
            value -= 2 ** bit
        return Decimal(value * magnification).quantize(Decimal(dc))

def trans_vl(vl):
    if not vl:
        return []
    v = []
    lt_b = {}
    lt = {}
    lt1 = {}
    lt2 = {}
    lt3 = {}
    lt4 = {}
    v.extend(re.findall(r'.{8}', vl[:496]))
    v.extend(re.findall(r'.{4}', vl[496:580]))
    v.extend(re.findall(r'.{8}', vl[580:612]))
    v.extend(re.findall(r'.{4}', vl[612:660]))
    for i in range(len(v)):
        if i in mo_map.keys():
            lt_b.update({mo_map[i]: signed_int_value(vl=v[i], **encrypt_map[i])})
            continue
        if i in mo_map_bk.keys():
            lt.update({mo_map_bk[i]: signed_int_value(vl=v[i], **encrypt_map[i])})
            continue
        elif i in mo_map_bk1.keys():
            lt1.update({mo_map_bk1[i]: signed_int_value(vl=v[i], **encrypt_map[i])})
            continue
        elif i in mo_map_bk2.keys():
            lt2.update({mo_map_bk2[i]: signed_int_value(vl=v[i], **encrypt_map[i])})
            continue
        elif i in mo_map_bk3.keys():
            lt3.update({mo_map_bk3[i]: signed_int_value(vl=v[i], **encrypt_map[i])})
            continue
        elif i in mo_map_bk4.keys():
            lt4.update({mo_map_bk4[i]: signed_int_value(vl=v[i], **encrypt_map[i])})
            continue
    lt.update(lt_b)
    lt1.update(lt_b)
    lt2.update(lt_b)
    lt3.update(lt_b)
    lt4.update(lt_b)
    return [lt4, lt3, lt2, lt1, lt]

# vl = '00035C2800035C2800035C2800035C2800035C280003613C0003613C0003613C0003613C0003613C00035FAC00035FAC00035FAC00035FAC00035FAC0005D6240005D6240005D6240005D6240005D6240005D9440005D9440005D9440005D9440005D9440005D4940005D4940005D4940005D4940005D494000005DC000005DC000005DC000005DC000005DC000005DC000005DC000005DC000005DC000005DC000005DC000005DC000005DC000005DC000005DC0000000000000000000000000000000000000000FFFFFEB6FFFFFEB3FFFFFEB4FFFFFC1C0000000400000002000000070000000E0000014B0000014D0000014C000003E403E703E703E703E703E703E703E803E803E803E803E703E703E703E703E703E703E703E703E703E7138700000126000000030000000000000000003A00000000000000000000004200000000000000000000'
# print(trans_vl(vl))

