#!/usr/bin/env python
# -*- coding: utf-8 -*-
import logging

from drf_yasg.utils import swagger_auto_schema

from rest_framework.response import Response
from common.utils.views import AllowAnyApiView, OAProxyMonitorApiView
from common.utils.serializers import BaseResponesSerializer
from common.utils.services import monitor_service


logger = logging.getLogger('')


class OAMonitorV1View(OAProxyMonitorApiView):
    @swagger_auto_schema(
        operation_description="""
        OA监控 api 代理接口
        """,
        tags=['OA API'],
    )
    def post(self, request, *args, **kwargs):
        logger.debug("收到V1版本数据 %s" % request.data)
        """
        {
            "imei": "0202233123",
            "data": {
                "Line": 1,
                "Ua": 220.11,
                "Ub": 220.11,
                "Uc": 220.11,
                "Ia": 11.01,
                "Ib": 12.01,
                "Ic": 13.01,
                "Pa": 123.001,
                "Pb": 133.001,
                "Pc": 103.001,
                "Psum": 103.001,
                "Qa": 124.001,
                "Qb": 134.001,
                "Qc": 104.001,
                "Qsum": 204.001,
                "PFa": 0.981,
                "PFb": 0.971,
                "PFc": 0.991,
                "PF": 0.981,
                "FR": 50.01,
                "PX": 50.001,
                "EP": 50.001,
                "EQ1": 50.001,
                "EQ2": 50.001,
                "TC": 24.1
            },
            "T": 24,
            "S": 12,
            "Time": "14:59:00",
            "v": "0f8a6e9fc5b134b7"
        }

        :param request:
        :param args:
        :param kwargs:
        :return:
        """
