from rest_framework import serializers
from rest_framework.exceptions import ValidationError
from common.utils.serializers import BaseDataV1Serializer
from common.utils.encryption import imei_md5


class AcrelSerializer(serializers.Serializer):
    imei = serializers.CharField(max_length=32, help_text="sn号")
    data = BaseDataV1Serializer()
    t = serializers.FloatField(help_text="环境温度")
    s = serializers.FloatField(help_text="环境湿度")
    v = serializers.CharField(max_length=16, help_text="md5校验")

    def validate(self, attrs):
        sn = attrs.get("imei")
        dt_md5 = imei_md5(sn, "test")
        if dt_md5 != attrs.get("v"):
            raise ValidationError
        return attrs