import mock from '../../../../mock/map';
import request from './request';
import * as _ from 'lodash'

const requestMock = url => {
  return Promise.resolve(mock[url]);
};

export const getPeopleReal = params =>
  request('/api/v1/console/OMS/dashboard/user_location', { params });
export const getPeopleLast = params =>
  request('/api/v1/console/OMS/dashboard/last_location', { params });

/**
 * 资产清单
*/
export const getAssets = number =>
  request(`/api/v1/console/OMS/dashboard/numbers/${number}/details`);

export const getVehicle = params =>
  request('/api/v1/console/OMS/dashboard/cars', { params });
export const getCustomer = params =>
  request('/api/v1/console/OMS/dashboard/customers', { params });

/**
 * 登录
*/
export const login = (params) => request.post('/api/v1/login', params)

/**
 * 汇总数据
*/
export const getRealTimeData = (params = {}) => {
  return request(`/api/v1/console/OMS/dashboard/summary`, {
    params: _.omitBy(params, item => !item)
  });
}

/**
 * 统计数据
*/
export const getStatisticsData = () => request('/api/v1/console/OMS/dashboard/statistics')
export const getWeather = () => request('/api/v1/console/OMS/dashboard/weather')

/**
 * 户号详情
*/
export const getCustomerDetail = (id = 1) => request(`/api/v1/console/OMS/dashboard/numbers/${id}/details`)
export const getDefectList = () => request('/api/v1/console/OMS/spect/defect')
export const getAlarmList = () => request('/api/v1/console/OMS/dashboard/monitor/alarm')
export const getRepairList = () => request('/api/v1/console/OMS/task/tasks', { type: 'rush_to_repair' })
// export const getEnergy = () => requestMock('/api/v1/console/OMS/dashboard/ele')
export const getMonitorPoints = (number, stationId) => request(`/api/v1/console/monitor/old/numbers/${number}/stations/${stationId}/points`)
export const getRealData = (number, stationId, pointId) => request(`/api/v1/console/monitor/old/numbers/${number}/stations/${stationId}/points/${pointId}/real_data`)
export const getPeakData = ({ number, stationId, point, startTime, endTime }) =>
  request(`/api/v1/console/monitor/old/numbers/${number}/stations/${stationId}/points/${point}/statisticsdata?start_time=${startTime}&end_time=${endTime}`)
export const getEnergy = ({ number, stationId, point }) =>
  request(`/api/v1/console/monitor/old/numbers/${number}/stations/${stationId}/points/${point}/statisticsdata?value=power_curve`)
export const getMonitorData = ({ number, stationId, point, startTime, endTime, query = '' }) =>
  request(`/api/v1/console/monitor/old/numbers/${number}/stations/${stationId}/points/${point}/data?start_time=${startTime}&end_time=${endTime}${query}`)
// export const getMonitorData = ({ number, stationId, point, startTime, endTime, query = '' }) =>
//   requestMock(`/api/v1/console/monitor/old/numbers/data`)
export const getSafeTool = () => requestMock('/api/v1/console/OMS/dashboard/safeTool')
// export const getLiveVideo = () => request('/api/v1/console/OMS/dashboard/monitor/videos')
export const getLiveVideo = (stationId) => request(`/api/v1/console/OMS/dashboard/monitor/${stationId}/videos`)

export const getCircuitItem = stationId =>
request(`/api/v1/console/OMS/powerstation/${stationId}/circuit?power_station_id=${stationId}`);

// 大屏实时数据
export const realDataMonitor = ({
  startTime = '',
  endTime = '',
  province = '',
  city = '',
  enterprise_id
}) => {
  const params = {
    real: '1',
    start_time: startTime,
    end_time: endTime,
    province,
    city,
    enterprise_id
  };
  return request(`/api/v1/console/OMS/dashboard/monitor/real_data`, {
    params: _.omitBy(params, (item) => !item)
  })
}

// 大屏地图折线
export const getPayloadData = ({
  startTime = '',
  endTime = '',
  province = '',
  city = '',
}) => {
  const params = {
    real: '0',
    start_time: startTime,
    end_time: endTime,
    province,
    city,
  }
  return request(`/api/v1/console/OMS/dashboard/monitor/real_data`, {
    params: _.omitBy(params, (item) => !item)
  })
}

// 左侧月汇总数据
export const getMonthTotal = params => request('/api/v1/console/OMS/dashboard/monitor/month_ep', {
  params: _.omitBy(params, (item) => !item)
})

// 获取实时视频url
export const getLiveVideoUrl = userId =>
  request(`/api/v1/console/video_management/${userId}/video_url`, {method: 'post'});
