import React, {memo} from 'react';
import { useSize } from '@umijs/hooks';
import { connect } from 'dva';
import Map from './Map';
import MonthTotal from './MonthTotal';
import RealTimeData from './RealTimeData';
import Inspection from './Inspection';
import TabPanel from './TabPanel';
import ScreenHeader from './ScreenHeader';
import styles from './index.less';
import TrustEnergy from './TrustEnergy';
import Microgrid from './Microgrid';

import {featureEnum} from './constants';

const WIDTH = 3072;
const HEIGHT = 896;

const Screen = ({features}) => {
  const [{ width, height }] = useSize(window.document.body);
  const scaleX = width / WIDTH;
  const scaleY = height / HEIGHT;
  const style = {
    width: WIDTH,
    height: HEIGHT,
    transform: `scale(${scaleY}`,
    transformOrigin: 'left top',
  };

  return (
    <div style={{width, height, position: 'relative'}}>
      <div style={style} className={styles.content}>
        <ScreenHeader />
        <div className={styles.body}>
          <div className={styles.left}>
            <TrustEnergy />
            <MonthTotal />
            <RealTimeData />
            <Inspection />
          </div>
          <div className={styles.center}>
            <Map width={WIDTH * scaleY} scale={scaleY} />
          </div>
          <div className={styles.right}>
            {
              features.includes(featureEnum.eleNet)
                ? <Microgrid />
                : <TabPanel />
            }
          </div>
        </div>
        <div className={styles.bg}></div>
      </div>
    </div>
  );
}
export default connect(({screen}) => {
  const {features} = screen;
  return {
    features
  }
})(memo(Screen))
