import React from 'react';
import classNames from 'classnames';
import styles from './index.less';
import trendUp from '../../../../resource/images/screen/data_up.png';
import trendDown from '../../../../resource/images/screen/data_down.png';

export default React.memo(({
  title='',
  num=0,
  up=true,
  wrapClassName,
  layout='column',
  hasBorder=false,
  isNormal
}) => {
  const warpClassNames = classNames(styles.trendWrap,
    {
      [styles.trendWrapRow]: layout !== 'column',
      [styles.trendWithBorder]: hasBorder,
      [styles.trendDown]: !up,
      [styles.trendUp]: up,
      [styles.trendWrapNormal]: isNormal
    },
    wrapClassName,
  );
  return <div className={warpClassNames}>
    <div className={styles.trendTitle}>{title}</div>
    <div className={styles.trendData}>
      <img
        src={up ? trendUp : trendDown}
        className={styles.trendIcon}
      />
      <span className={styles.trendNum}>{num * 1000 / 10}%</span>
    </div>
  </div>
});
