import React from 'react';
import cls from 'classnames';
import styles from './index.less';

export default function Modal({
  className,
  children,
  onClose,
  ...props
}) {
  return (
    <div className={cls(styles.modal, className)} {...props}>
      {onClose && (
        <div className={styles.close} onClick={onClose}>
          x
        </div>
      )}
      {children}
    </div>
  );
}
