import React, { memo } from 'react';
import classNames from 'classnames';
import styles from './index.less';

export default React.memo(({num=0, style={}, size='large', isNormal}) => {
  const wrapClassNames = classNames({
    [styles.bigData]: size === 'large',
    [styles.bigDataNormal]: size !== 'large',
    [styles.bigDataWrapNormal]: isNormal
  });

  return <div
    className={wrapClassNames}
    style={style}
  >
    {Number(num).toLocaleString()}
  </div>
});

// TODO: 数字的渲染替换为此组件

const handlers = {
  normal: props => {
    const {showLocale, num, toFixed} = props;
    const fixedNum = toFixed > -1 ? Number(num).toFixed(toFixed) : num;
    return showLocale ? Number(fixedNum).toLocaleString() : fixedNum;
  },
  percent: props => {
    const {toFixed, num} = props;
    return toFixed > -1 ? (num * 100).toFixed(toFixed) + '%' : num * 100 + '%';
  }
};

export const ColorNum = memo(props => {
  const defaultProps = {
    num: 0,
    numMode: 'normal', // normal, percent
    toFixed: -1, // 保留小数位数
    showLocale: false, // 逗号分隔
    color: 'blue', // 颜色为预设蓝色
    size: 18, // 字体大小
    shadow: true, // 阴影
    italic: false, // 斜体
    weight: 'bold',
    customCls: ''
  };

  const innerProps = {
    ...defaultProps,
    ...props
  };
  const wrapClass = classNames({
    [styles[`${innerProps.color}Theme`]]: true,
    [styles.withShadow]: innerProps.shadow,
    [styles.withItalic]: innerProps.italic
  }, innerProps.customCls);

  return <span
      style={{
        fontSize: innerProps.size + 'px',
        fontWeight: innerProps.weight
      }}
      className={wrapClass}
  >{handlers[innerProps.numMode](innerProps)}</span>

})
