import React from 'react';
import { Cascader } from 'antd';
import { CaretDownOutlined } from '@ant-design/icons';
import cls from 'classnames';
import './index.less';

const options = [
  {
    value: 'zhejiang',
    label: 'Zhejiang',
    children: [
      {
        value: 'hangzhou',
        label: 'Hangzhou',
        children: [
          {
            value: 'xihu',
            label: 'West Lake',
          },
        ],
      },
    ],
  },
  {
    value: 'jiangsu',
    label: 'Jiangsu',
    children: [
      {
        value: 'nanjing',
        label: 'Nanjing',
        children: [
          {
            value: 'zhonghuamen',
            label: 'Zhong Hua Men',
          },
        ],
      },
    ],
  },
];

export default React.memo(function ACascader(props) {
  return (
    <Cascader
      suffixIcon={<CaretDownOutlined />}
      bordered={false}
      {...props}
      className={cls('a-cascader', props.className)}
      popupClassName={cls('a-cascader-menus', props.popupClassName)}
    />
  );
});
