/**
 * @file 托管电量
 * @author  yangzhong01
 * @date 2021/4/24
 */
import React, { memo, useEffect, useRef, useState } from 'react';
import { connect } from 'dva';
import classNames from 'classnames';
import styles from './index.less';
import { ColorNum } from '@/pages/screen/components/BigData';
import CountTo from 'react-count-to';

export default connect(({overview, screen}) => {
  const {
    sumActiveEnergy,
    sumReactiveEnergy
  } = overview;
  const {
    company,
    area
  } = screen;
  return {
    sumActiveEnergy,
    sumReactiveEnergy,
    company,
    area
  }
})(memo(({
  sumActiveEnergy,
  sumReactiveEnergy,
  dispatch,
  isNormal
}) => {
  const numSize = isNormal ? '36' : '25';
  const [mounted, setMounted] = useState(false);
  useEffect(() => {
    if (mounted) {
      return;
    }
    setMounted(true);
    // 轮询
    const timer = setInterval(() => {
      dispatch({type: 'overview/fetchScreenRealData'});
    }, 5000)
  }, [mounted])
    const fn = val => (
      <ColorNum
        color="orange"
        num={val}
        size={numSize}
        italic={true}
        shadow={false}
        toFixed={0}
      />
    )
  const fn2 = val => (
    <ColorNum
      color="orange"
      num={val}
      size={numSize}
      italic={true}
      shadow={false}
      toFixed={0}
    />
  )

  const prevAeRef = useRef();
  useEffect(() => {
    prevAeRef.current = sumActiveEnergy;
  });

  const prevReRef = useRef();
  useEffect(() => {
    prevReRef.current = sumReactiveEnergy;
  });

  const wrapCls = classNames(styles.wrapper, {[styles.normalScreen]: isNormal})
    return <div className={wrapCls}>
    <div className={styles.header}>托管电量</div>
    <div className={styles.contents}>
      <div className={styles.item}>
        <span className={styles.label}>累计有功电量（kWh）：</span>
        <CountTo from={prevAeRef.current} to={sumActiveEnergy} speed={1000}>{fn}</CountTo>
      </div>
      <div className={styles.item}>
        <span className={styles.label}>累计无功电量（kVarh）：</span>
        <CountTo from={prevReRef.current} to={sumReactiveEnergy} speed={1000}>{fn2}</CountTo>
      </div>
    </div>
  </div>
}))
