import React, {useState} from 'react';
import classNames from 'classnames';
import { connect } from 'dva';
import styles from './index.less';
import repair_light from '../../../resource/images/screen/repair_light.png';
import repair_shallow from '../../../resource/images/screen/repair_shallow.png';
import warning_light from '../../../resource/images/screen/warning_light.png';
import warning_shallow from '../../../resource/images/screen/warning_shallow.png';
import defect_light from '../../../resource/images/screen/defect_light.png';
import defect_shallow from '../../../resource/images/screen/defect_shallow.png';
import tabImgActiveBg from '../../../resource/images/screen/tab_active_bg.png';
import card_warning from '../../../resource/images/screen/card_warning.png';
import defect_img from '../../../resource/images/screen/defect_img.png';
import {RepairTaskEnum, TabList, AlarmMap, DispatchDataMap} from '../constants';

// TODO: 抢修列表缺少班组、组长字段
const imgMaps = {
  repair_light,
  repair_shallow,
  warning_light,
  warning_shallow,
  defect_light,
  defect_shallow
}

const formateTime = t => {
  const time = new Date(t);
  return `${time.getHours()}:${time.getMinutes() < 10 ? '0' + time.getMinutes() : time.getMinutes()}`;
}

const RepairItem = ({
  item,
  onClickTask
}) => {
  const wrapClassNames = classNames(
    styles.repairItem,
    {
      [styles.repairNoDispatch]: item.status === RepairTaskEnum.waiting_dispatch,
      [styles.repairDoing]: item.status === RepairTaskEnum.in_process.key,
      [styles.repairPending]: item.status === RepairTaskEnum.pending,
    }
  );
  return <div className={wrapClassNames}>
    <div className={styles.cardItemLine}></div>
    <div className={styles.taskStatus}>{RepairTaskEnum[item.status].text}</div>
    <div className={styles.taskContent}>
      <div className={styles.taskHead}>
        <div className={styles.taskTitle} onClick={onClickTask}>{item.name}</div>
        <div className={styles.taskCreateTime}>产生时间：{formateTime(item.created_time)}</div>
      </div>
      <div className={styles.taskBottom}>
        <div title={item.customer.name}>{item.customer.name.substring(0,7)}...</div>
        <div title={item.team && item.team.name}>负责班组：{item.team && item.team.name.substring(0,7)}</div>
        <div>组长：{item.team && item.team.team_headman}</div>
      </div>
    </div>
  </div>
};

const WarningItem = ({
  item
}) => {
  const {
    alarm_type,
    duration,
    point_name,
    customer_name,
    start_time
  } = item;
  return <div className={styles.warningItem}>
    <div className={styles.cardItemLine}></div>
    <div>
      <img src={card_warning} alt="" className={styles.warningImg}/>
    </div>
    <div className={styles.warningContent}>
      <div className={styles.warningHead}>
        <div className={styles.warningTitle}>{AlarmMap[alarm_type]}</div>
        <div className={styles.warningCreateTime}>持续时间{duration}min</div>
      </div>
      <div className={styles.warningBottom}>
        <div>{point_name}</div>
        <div title={customer_name}>{customer_name.substring(0,7)}...</div>
        <div>{formateTime(start_time)}</div>
      </div>
    </div>
  </div>
};

const DefectItem = ({
  item
}) => {
  const {name, station, customer, created_time} = item;
  return <div className={styles.defectItem}>
    <div className={styles.cardItemLine}></div>
    <div>
      <img src={defect_img} alt="" className={styles.defectImg}/>
    </div>
    <div className={styles.defectContent}>
      <div className={styles.defectHead}>
        <div className={styles.defectTitle}>{name}</div>
      </div>
      <div className={styles.defectBottom}>
        <div title={station.name}>{station.name.substring(0, 7)}</div>
        <div title={customer.name}>{customer.name.substring(0, 7)}</div>
        <div>{created_time ? formateTime(created_time) : ''}</div>
      </div>
    </div>
  </div>
};

@connect(({ overview }) => ({ ...overview}))
export default class TabPanel extends React.PureComponent {

  componentDidMount() {
    const {dispatch, currentTab} = this.props;
    dispatch({
      type: 'overview/fetchTabData',
      payload: {
        currentTab
      }
    })
  }

  switchTab = ({value}) => {
    const {dispatch} = this.props;
    dispatch({
      type: 'overview/fetchTabData',
      payload: {
        currentTab: value
      }
    })
  }

  onClickTask = (task) => {
    console.log('task', task)
    this.props.dispatch({
      type: 'screen/handleSelectedPoint',
      payload: {
        type: DispatchDataMap.customer,
        id: task.customer.id,
      }
    })
  }

  getImgSrc = (item) => {
    const {currentTab} = this.props;
    if (currentTab === item.value) {
      return imgMaps[`${item.value}_light`];
    }
    return imgMaps[`${item.value}_shallow`];
  }

  render() {
    const {
      currentTab,
      isNormal,
      repairData,
      warningData,
      defectData
    } = this.props;

    const data = {
      repairData,
      warningData,
      defectData
    };

    const currentData = data[`${currentTab}Data`];

    const wrapListClassNames = classNames(
      styles.cardList,
      {
        [styles.cardListLess]: currentData.length < 2
      }
    );

    return <div className={isNormal ? styles.panelTabWrapNormal : styles.panelTabWrap}>
      <div className={styles.panelTab}>
        {
         TabList.map(item => (
          <div
            className={item.value === currentTab ? styles.tabActive : styles.tabItem}
            onClick={() => this.switchTab(item)}
            key={item.value}
          >
            <img
              src={this.getImgSrc(item)}
              className={styles.tabImg}
            />
            <span className={styles.tabTitle}>{item.text + `（${data[item.value + 'Data'].length}）`}</span>
            <img
              src={tabImgActiveBg}
              className={styles.tabActiveBg}
              style={{visibility: item.value === currentTab ? '' : 'hidden'}}
            />
          </div>
         ))
        }
      </div>
      <div className={styles.scrollWrapper}>
        <div className={wrapListClassNames}>
          <div className={styles.cardListLine}></div>
          {currentData.map((item, index) => {
          return currentTab === 'repair' ? <RepairItem key={index} item={item} onClickTask={() => this.onClickTask(item)} />
            : currentTab === 'warning' ? <WarningItem key={index} item={item} />
            : <DefectItem key={index} item={item} />
          })}
        </div>
      </div>
    </div>
  }
}
