import React, { useEffect, useRef, useState } from 'react';
import { connect } from 'dva';
import classNames from 'classnames';
import styles from './index.less';
import Trend from '../components/Trend';
import {ColorNum} from '../components/BigData';
import MonthSelect from '../components/MonthSelect';
import CountTo from 'react-count-to';

export default connect(({ overview }) => ({ ...overview }))(
  React.memo(props => {
    const {month, useElectricData, dispatch, isNormal} = props;
    const [flag, setFlag] = useState(false);
    useEffect(() => {
      if (flag) {
        return;
      }
      setFlag(true);
      const timer = setInterval(() => {
        // dispatch
        dispatch({type: 'overview/fetchMonthEp'})
      }, 15 * 1000);

      return () => {
        clearInterval(timer);
      }
    }, [])

    const prevPeRef = useRef();
    useEffect(() => {
      prevPeRef.current = useElectricData.total;
    });
    const countFn = val => (
      <ColorNum
        toFixed={0}
        showLocale={true}
        shadow
        num={val}
        weight={500}
        size={30}
        customCls={styles.colorNum}
      />
    );
    const onMonthChange = index => {
      dispatch({
        type: 'overview/changeMonth',
        payload: index
      })
      dispatch({
        type: 'overview/onMonthChange',
        payload: index
      })
    }
    const wrapClassNames = classNames(styles.monthTotal, {
      [styles.monthTotalNormal]: isNormal
    })
    return <div className={wrapClassNames}>
        <div className={styles.leftIcon}></div>
        <div className={styles.monthCenter}>
          <div>
            <span style={{marginRight: '15px'}}>月总用电量（kWh）</span>
            {/*<MonthSelect*/}
            {/*  value={month}*/}
            {/*  onSelect={onMonthChange}*/}
            {/*  isNormal={isNormal}*/}
            {/*/>*/}
          </div>
          <div className={styles.monthCenterDown}>
            <Trend
              title="月环比"
              num={Math.abs(useElectricData.month)}
              up={useElectricData.month > 0}
              wrapClassName={styles.trendLeft}
              isNormal={isNormal}
            />
            <Trend
              title="年同比"
              num={Math.abs(useElectricData.year)}
              up={useElectricData.year > 0}
              isNormal={isNormal}
            />
          </div>
        </div>
        <CountTo
          from={prevPeRef.current}
          to={useElectricData.total}
          speed={1000}
        >
          {countFn}
        </CountTo>
    </div>
  })
);
