/**
 * @file 可点击单元格
 * @author  yangzhong01
 * @date 2021/4/27
 */

import React, {memo, useState, useCallback} from 'react';
import classnames from 'classnames';
import ComingSoonText from '../../../components/ComingSoon';

import styles from './index.less';

export default (FrontSide, BackSide) => memo(props => {
  const [flag, setFlag] = useState(true);

  const {wrapper, header, label, desc, num, contentWrap,
    contentItem, hideItem, activeItem, headerBetween, headerNormal,
    bottomBorder, normalScreen, comingSoonItem
  } = styles;
  const {
    category = '',
    attr = '',
    value = '',
    enable = true,
    hasConnection = true,
    hasBottomBorder = false,
    isNormal,
    headerStyle = {},
    className,
    comingSoon = false,
    frontProps = {}
  } = props;

  const frontItemClass = classnames({
    [contentItem]: true,
    [activeItem]: flag,
    [hideItem]: !flag
  })

  const backItemClass = classnames({
    [contentItem]: true,
    [activeItem]: !flag,
    [hideItem]: flag
  })

  const headerClass = classnames({
    [header]: true,
    [headerNormal]: true,
    [headerBetween]: false // TODO: 不同屏幕适配
  })

  const wrapCls = classnames(wrapper, {
    [bottomBorder]: hasBottomBorder,
    [normalScreen]: isNormal
  }, className)

  return (
    <div className={wrapCls} onClick={() => enable && setFlag(!flag)}>
      <div className={headerClass} style={headerStyle}>
        <div className={label}>{category}</div>
        {!comingSoon && attr && (
          <div>
            <span className={desc}>{`${attr}${hasConnection ? '：' : ''}`}</span>
            <span className={num}>{value}</span>
          </div>
        )}
      </div>
      <div className={contentWrap}>
        {
          comingSoon && <div className={comingSoonItem}>
            <ComingSoonText />
          </div>
        }
        {
          !comingSoon && <div className={frontItemClass}>
            {flag && <FrontSide {...frontProps}/>}
          </div>
        }
        {
          !comingSoon && <div className={backItemClass}>
            {!comingSoon && !flag && <BackSide />}
          </div>
        }
      </div>
    </div>
  );
});
