import React, { memo } from 'react';
import classNames from 'classnames';
import Photovoltaic from '@/pages/screen/Microgrid/components/Photovoltaic';
import EnergyStorage from '@/pages/screen/Microgrid/components/EnergyStorage';
import ChargingPile from '@/pages/screen/Microgrid/components/ChargingPile';
import Lately30Charging from '@/pages/screen/Microgrid/components/LateLy30Charging';
import styles from './index.less';

const {wrapper, innerWrapper, hengLine, shuLine, normalScreen} = styles;

export default memo((
  {
    isNormal,
    photovoltaic,
    energyStorage,
    fetchRealData,
    chargingPile,
    lateLy30Charging,
    isModal,
    extra = {}
  }
) => {
  const wrappers = classNames(innerWrapper, {[normalScreen]: isNormal})
  return (
    <div className={wrappers}>
      <div className={wrapper} style={isModal ? {background: 'none'} : {}}>
        {!isNormal && <div className={shuLine}></div>}
        <Photovoltaic {...photovoltaic} isNormal={isNormal} fetchRealData={fetchRealData} isModal={isModal}/>
        <EnergyStorage {...energyStorage} isNormal={isNormal} extra={extra} isModal={isModal}/>
      </div>
      {!isNormal && <div className={hengLine}></div>}
      <div className={wrapper} style={isModal ? {background: 'none'} : {}}>
        <ChargingPile {...chargingPile} isNormal={isNormal} extra={extra} isModal={isModal}/>
        <Lately30Charging lateLy30Charging={lateLy30Charging} isNormal={isNormal} isModal={isModal} />
      </div>
    </div>
  )
});
