/**
 * @file
 * @author  yangzhong01
 * @date 2021/4/29
 */
import React, {memo, useMemo} from 'react';
import {get} from 'lodash';
import BarStack from '../../../components/echarts/bar';
import withClickCell from '../../components/withClickCell';

const getLately30Day = () => {
  const now = new Date();
  const nowTime = new Date(`${now.getFullYear()}/${now.getMonth() + 1}/${now.getDate()}`).getTime()
  return new Array(30).fill(1).map((item, index) => {
    const current = new Date(nowTime - index * 24 * 60 * 60 * 1000);
    return `${current.getFullYear()}-${current.getMonth()+1}-${current.getDate()}`;
  }).reverse();
};

const barSize = {
  normal: {
    modal: {
      w: 280,
      h: 200
    },
    right: {
      w: 450,
      h: 320
    }
  },
  big: {
    modal: {
      w: 280,
      h: 200
    },
    right: {
      w: 280,
      h: 250
    }
  }
};
export default memo(({lateLy30Charging, isNormal, isModal}) => {
  const frontProps = useMemo(() => {
    const path = `${isNormal ? 'normal' : 'big'}.${isModal ? 'modal' : 'right'}`;
    console.log('path', path)
    const series = isModal ? lateLy30Charging.map(item => item / 10) : lateLy30Charging;
    return {
      ...get(barSize, path, {}),
      series
    };
  }, [lateLy30Charging, isModal, isNormal])
  const FrontSide = ({w, h, series}) => (
    <BarStack
      title={{text: "光伏发电功率", show: false}}
      xAxis={{data: getLately30Day()}}
      yAxis={{name: 'kWh'}}
      series={[{data: series}]}
      style={{width: w, height: h, margin: '0 auto'}}
      grid={{
        x: 15,
        y: 15,
        x2: 15,
        y2: 15
      }}
    />
  );
  const Lately30Charging = withClickCell(FrontSide, null);
  return (
    <Lately30Charging
      enable={false}
      headerSize={13}
      attr="近30天充电量"
      hasConnection={false}
      isNormal={isNormal}
      headerStyle={{justifyContent: isNormal ? 'flex-end' : 'flex-start'}}
      hasBottomBorder={false}
      frontProps={frontProps}
    />
  );
});
