/**
 * @file 储能
 * @author  yangzhong01
 * @date 2021/4/24
 */
import React, {memo} from 'react';
import withClickCell from '../withClickCell';
import LiquidFillBox from '../LiquidFillBox';
import TextAndValue from '../../../components/TextAndValue';

import styles from './index.less';

const {flexLine, backSideCls, attrItem} = styles;

export default memo(props => {
  const {
    total,
    realPower,
    totalAssemblyCapacity,
    sumCharging,
    sumDischarge,
    avgEfficiency,
    sumProfit,
    theoryProfit,
    isNormal,
    extra,
    isModal
  } = props;

  const {
    sumChargingUnit = 'kWh',
    sumDischargeUnit = 'kWh',
    sumProfitUnit = '万元',
    theoryProfitUnit = '万元'
  } = extra;
  const FrontSide = memo(() => (
    <LiquidFillBox
      bottom={{attr: '实时功率', num: realPower, unit: 'kW'}}
      top={{attr: '总装接容量', num: totalAssemblyCapacity, unit: sumChargingUnit}}
      horizontal={isNormal}
    />
  ));

  const BackSide = memo(() => (
    <div className={backSideCls}>
      <div className={flexLine}>
        <TextAndValue text={`累计充电量（${sumChargingUnit}）`} isNormal={isNormal} value={sumCharging} />
        <TextAndValue text={`累计放电量（${sumDischargeUnit}）`} isNormal={isNormal} value={sumDischarge} />
      </div>
      <div className={flexLine}>
        <TextAndValue text={`累计收益（${sumProfitUnit}）`} isNormal={isNormal} value={sumProfit} />
        <TextAndValue text={`理论收益（${theoryProfitUnit}）`} isNormal={isNormal} value={theoryProfit} />
        {isNormal && <TextAndValue text="平均效率" isNormal={isNormal} value={avgEfficiency} />}
      </div>
      {!isNormal && <div>
        <TextAndValue text="平均效率" isNormal={isNormal} value={avgEfficiency} />
      </div>}
    </div>
  ));


  const EnergyStorage = withClickCell(FrontSide, BackSide)
  return <EnergyStorage
    category="储能"
    attr={`总装机容量（${sumChargingUnit}）`}
    value={total}
    isNormal={isNormal}
    hasBottomBorder={isNormal}
  />
});
