/**
 * @file 充电桩
 * @author  yangzhong01
 * @date 2021/4/24
 */
import React, {memo} from 'react';
import classNames from 'classnames';
import withClickCell from '../withClickCell';
import TextAndValue from '../../../components/TextAndValue';
import RadarCanvas from '@/pages/screen/components/RadarCanvas';
import { ColorNum } from '@/pages/screen/components/BigData';


import styles from './index.less';

const {flexLine, front, right, left, num, backSideCls, wrapper, normalScreen, rightWrap} = styles;

export default memo(props => {
  const {
    sumCharging,
    realTimeUseRate,
    totalNum,
    dcPile,
    acPile,
    todayCharging,
    yesterdayCharging,
    monthCharging,
    lastMothCharging,
    isNormal,
    extra,
    isModal
  } = props;
  const canvasSize = isNormal ? 290 : 150;
  const numSize = isNormal ? '64' : '30';
  const {
    sumChargingUnit = 'kWh',
  } = extra;

  const wrapCls = f => classNames(wrapper, {
    [normalScreen]: isNormal,
    [front]: f,
    [backSideCls]: !f
  })
  const FrontSide = memo(() => (
    <div className={wrapCls(true)}>
      <div className={left}>
          <RadarCanvas
            theme="orange"
            canvasId="chargingPile"
            percent={realTimeUseRate}
            width={`${canvasSize}px`}
            height={`${canvasSize}px`}
            theme="orange"
          />
          <ColorNum
            customCls={num}
            num={realTimeUseRate}
            numMode="percent"
            toFixed={1}
            color="orange"
            size={numSize}
          />
      </div>
      <span className={right}>实时使用率</span>
    </div>
  ));

  const BackSide = memo(() => (
    <div className={wrapCls()}>
      <div className={flexLine}>
        <TextAndValue text="充电桩总数" isNormal={isNormal} value={totalNum} />
        <TextAndValue text="直流桩" isNormal={isNormal} value={dcPile} />
        <TextAndValue text="交流桩" isNormal={isNormal} value={acPile} />
      </div>
      <div className={flexLine}>
        <TextAndValue text="今日已充电量（kWh）" isNormal={isNormal} value={todayCharging} />
        <TextAndValue text="昨日充电量（kWh）" isNormal={isNormal} value={yesterdayCharging} />
      </div>
      <div className={flexLine}>
        <TextAndValue text="当月电量（kWh）" isNormal={isNormal} value={monthCharging} />
        <TextAndValue text="上月电量（kWh）" isNormal={isNormal} value={lastMothCharging} />
      </div>
    </div>
  ));


  const ChargingPile = withClickCell(FrontSide, BackSide)
  return <ChargingPile
    category="充电桩"
    attr={`累计充电量（${sumChargingUnit}）`}
    value={sumCharging}
    isNormal={isNormal}
  />
});
