import React, { useState } from 'react';
import { Input, Row, Col, Checkbox, Select } from 'antd';
import { CaretDownOutlined, SearchOutlined } from '@ant-design/icons';
import { connect } from 'dva';
import cls from 'classnames';
import get from 'lodash/get';
import { DispatchDataList, featureEnum } from '../../constants';
import styles from './index.less';

const { Option } = Select;

export default connect(({ screen }) => ({
  search: screen.search,
  features: screen.features,
  filterTypes: screen.filterTypes,
  dataList: [].concat(
    screen.vehicleList,
    screen.peopleList,
    screen.customerList,
  ),
}))(
  React.memo(function Tools(props) {
    const [selected, setSelected] = useState(DispatchDataList[0].value);
    const [inputVal, setVal] = useState('');
    const handleSearch = value => {
      const data = props.dataList.filter(item => item.type === selected);
      const ops = data.map(item => {
        return {
          label: item.label,
          value: item.id,
          number: item.number,
        };
      });
      return ops;
    };

    const handleFilterTypes = (val) => {
      props.dispatch({
        type: 'screen/handleFilterTypes',
        payload: val,
      });
    }

    const onSearch = value => {
      setVal(value);
    };
    const onSelect = value => {
      setVal(
        value ? props.dataList.find(item => item.id === value)['id'] : value,
      );
      props.dispatch({
        type: 'screen/handleSearchValue',
        payload: value,
      });
    };

    const handleTypeSelected = e => {
      setSelected(e);
      onSelect(null);
    };
    const show = DispatchDataList.find(item => item.value === selected).label;
    const filterOption = (input, option) => {
      return (
        (get(option, 'label', '') + '')
          .toLowerCase()
          .includes(input.toLowerCase()) ||
        (get(option, 'number', '') + '').includes(input)
      );
    };
    const showAIOps = props.features.includes(featureEnum.aiops);
    return (
      <Row className={styles.tools} justify="space-between">
        <Col>
          <Input.Group compact className={styles.group}>
            <Select
              value={show}
              className={styles.select}
              onChange={handleTypeSelected}
              bordered={false}
              suffixIcon={<CaretDownOutlined />}
              dropdownClassName={cls(styles.dropdown, {
                [styles.isNormal]: props.isNormal,
              })}
            >
              {DispatchDataList.filter(item => item.value !== selected).map(
                item => (
                  <Option value={item.value} key={item.value}>
                    {item.label}
                  </Option>
                ),
              )}
            </Select>
            <div className={styles.divider} />
            <Select
              className={cls(styles.select, styles.selectInput)}
              dropdownClassName={cls(styles.detailDropdown, {
                [styles.isNormal]: props.isNormal,
              })}
              style={{ width: 300 }}
              showSearch
              filterOption={filterOption}
              defaultActiveFirstOption={false}
              value={inputVal || null}
              onSearch={onSearch}
              onChange={onSelect}
              suffixIcon={<SearchOutlined />}
              options={handleSearch(inputVal)}
              placeholder="请输入"
              // getPopupContainer={triggerNode => triggerNode.parentNode}
            />
          </Input.Group>
        </Col>
        <Col>
          {showAIOps && (
            <Checkbox.Group
              value={props.filterTypes}
              className={styles.checkbox}
              options={DispatchDataList}
              onChange={handleFilterTypes}
            />
          )}
        </Col>
      </Row>
    );
  }),
);
