import React from 'react';
import { connect } from 'dva';
import videojs from 'video.js'
import AntdModal from '../../components/AntdModal';
import ele from '../../../../resource/images/screen/ele.mp4'
import styles from './index.less';
import 'video.js/dist/video-js.css';

class VideoPlayer extends React.Component {
  componentDidMount() {
    // instantiate Video.js
    this.player = videojs(this.videoNode, this.props, function onPlayerReady() {
      console.log('onPlayerReady', this)
    });
  }

  // destroy player on unmount
  componentWillUnmount() {
    if (this.player) {
      this.player.dispose()
    }
  }

  // wrap the player in a div with a `data-vjs-player` attribute
  // so videojs won't create additional wrapper in the DOM
  // see https://github.com/videojs/video.js/pull/3856
  render() {
    return (
      <div>	
        <div data-vjs-player>
          <video ref={ node => this.videoNode = node } className="video-js"></video>
        </div>
      </div>
    )
  }
}

export default connect(({ screen }) => ({
  video: screen.video
}))(React.memo(function RealVideo({ dispatch, video }) {
  const onClose = () => dispatch({ type: 'screen/handleVideo', payload: '' });
  const show = !!video;
  if (!show) {
    return null
  }
  const videoJsOptions = {
    autoplay: false,
    controls: true,
    width: '900',
    height: '520',
    sources: [{
      // src: 'https://bitdash-a.akamaihd.net/content/sintel/hls/playlist.m3u8',
      src: 'http://hls01open.ys7.com/openlive/cc9073571e0c471ca4224debb3ac5eca.m3u8',
      type: 'application/x-mpegURL'
    }]
  }
  // FIXME: 切换正式视频
  return (
    <AntdModal className={styles.box} onClose={onClose}>
      <VideoPlayer { ...videoJsOptions } />
    </AntdModal>
  );
}))
