import React, { useMemo } from 'react';
import { connect } from 'dva';
import get from 'lodash/get';
import map from 'lodash/map';
import FlvVideoPlayer from '../../components/FlvVideoPlayer';
import AntdModal from '../../components/AntdModal';
import Select from '../../components/Select';
import styles from './style.less';

class PlayerModal extends React.PureComponent {
  componentDidMount() {
    // 接口调用
    if (this.props.videoSource !== 'people') {
      const stationId = get(this.props.selectedCustomerStation, 'id');
      this.props.onLiveVideo(stationId);
    }
  }

  onChange = (item) => {
    this.props.dispatch({
      type: 'screen/handleVideoDiviceId',
      payload: item.value
    })
  }

  render() {
    const { liveVideo = [], videoDiviceId, videoSource, peopleVideo } = this.props;
    const commonVideo = liveVideo.find(item => item.deviceId == videoDiviceId) || {}
    const normalUrl =
      '/live/video.flv?devid=860723046177644&channel=1&devline=0';
    // 截取相对地址
    // const reg = /^http[s]?:\/\/[^\/]+(.*)/
    // const url = reg.test(flashUrl) ? flashUrl.match(reg)[1] : flashUrl;
    const videoParams = videoSource === 'people' ? peopleVideo : commonVideo;
console.log('videoParams', videoParams)
    return (
      <AntdModal
        onClose={() => this.props.showLiveVideo()}
        className={styles.wrapModal}
      >
        <div className={styles.videoModalWrap}>
          <Select
            className={styles.select}
            onSelect={this.onChange}
            options={map(liveVideo, item => ({
              label: item.name,
              value: item.deviceId,
            }))}
            value={videoDiviceId}
          />
          {videoParams && videoParams.url ? (
            <FlvVideoPlayer
              key={videoDiviceId}
              token={videoParams.token}
              playerType={0}
              src={videoParams.url}
            />
          ) : null}
        </div>
      </AntdModal>
    );
  }
}

export default connect(({ screen }) => ({
  selectedCustomerStation: screen.selectedCustomerStation,
  videoDiviceId: screen.videoDiviceId,
  peopleVideo: screen.peopleVideo,
  videoSource: screen.videoSource
}))(PlayerModal);
