import React from 'react';
import cls from 'classnames';
import { connect } from 'dva';
import { featureEnum, DispatchDataMap } from '@/pages/screen/constants';
import * as _ from 'lodash';
import './index.less';

const Item = ({ icon, text, selected, onClick }) => (
  <div className={cls('map-feat-item', { selected })} onClick={onClick}>
    <div className={`feat ${icon}`}></div>
    <div className="map-feat-item-text">{text}</div>
  </div>
);

export default connect(({ screen }) => {
  return {
    features: screen.features,
  };
})(
  React.memo(function Feature(props) {
    const { features, dispatch } = props;
    const onClick = val => {
      dispatch({
        type: 'screen/filterFeatures',
        payload: val,
      });
    };
    // React.useEffect(() => {
    //   props.filter(pointData => {
    //     let hasFeature = true;
    //     if (props.features.length > 0) {
    //       hasFeature = _.filter(pointData.features, (item) => props.features.includes(item)).length > 0;
    //     }
    //     const showPoint = pointData.type === DispatchDataMap.customer ? hasFeature : true;
    //     return showPoint;
    //   });
    // }, [props.features]);
    return (
      <div className="map-feat">
        <Item
          text="智慧运维"
          icon="feat-aiops"
          selected={features.includes(featureEnum.aiops)}
          onClick={() => onClick(featureEnum.aiops)}
        />
        <Item
          text="智慧能效"
          icon="feat-aipower"
          selected={features.includes(featureEnum.aiEnergy)}
          onClick={() => onClick(featureEnum.aiEnergy)}
        />
        <Item
          text="资产管理"
          icon="feat-res"
          selected={features.includes(featureEnum.asset)}
          onClick={() => onClick(featureEnum.asset)}
        />
        <Item
          text="电气安全"
          icon="feat-safe"
          selected={features.includes(featureEnum.eleSafe)}
          onClick={() => onClick(featureEnum.eleSafe)}
        />
        <Item
          text="大数据分析"
          icon="feat-data"
          selected={features.includes(featureEnum.bigData)}
          onClick={() => onClick(featureEnum.bigData)}
        />
        <Item
          text="微电网"
          icon="feat-wei"
          selected={features.includes(featureEnum.eleNet)}
          onClick={() => onClick(featureEnum.eleNet)}
        />
      </div>
    );
  }),
);
